/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Value<V>
implements Serializable {
    private static final Value<Object> EMPTY = new Value<Object>(null);
    private final V value;

    protected Value() {
        this.value = null;
    }

    protected Value(V value) {
        this.value = value;
    }

    public static <T extends V, V> Value<V> from(Optional<T> optional) {
        LettuceAssert.notNull(optional, "Optional must not be null");
        if (optional.isPresent()) {
            return new Value<T>(optional.get());
        }
        return EMPTY;
    }

    public static <T extends V, V> Value<V> fromNullable(T value) {
        if (value == null) {
            return Value.empty();
        }
        return new Value<T>(value);
    }

    public static <V> Value<V> empty() {
        return EMPTY;
    }

    public static <T extends V, V> Value<V> just(T value) {
        LettuceAssert.notNull(value, "Value must not be null");
        return new Value<T>(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value value1 = (Value)o;
        return this.value != null ? this.value.equals(value1.value) : value1.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.hasValue() ? String.format("Value[%s]", this.value) : "Value.empty";
    }

    public V getValue() {
        if (!this.hasValue()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public V getValueOrElseGet(Supplier<V> otherSupplier) {
        LettuceAssert.notNull(otherSupplier, "Supplier must not be null");
        if (this.hasValue()) {
            return this.value;
        }
        return otherSupplier.get();
    }

    public V getValueOrElse(V other) {
        if (this.hasValue()) {
            return this.value;
        }
        return other;
    }

    public <X extends Throwable> V getValueOrElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        LettuceAssert.notNull(exceptionSupplier, "Supplier function must not be null");
        if (this.hasValue()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <R> Value<R> map(Function<? super V, ? extends R> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new Value<R>(mapper.apply(this.getValue()));
        }
        return this;
    }

    public void ifHasValue(Consumer<? super V> consumer) {
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        if (this.hasValue()) {
            consumer.accept(this.getValue());
        }
    }

    public void ifHasValueOrElse(Consumer<? super V> consumer, Runnable emptyAction) {
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        LettuceAssert.notNull((Object)emptyAction, "EmptyAction must not be null");
        if (this.hasValue()) {
            consumer.accept(this.getValue());
        } else {
            emptyAction.run();
        }
    }

    public void ifEmpty(Runnable runnable) {
        LettuceAssert.notNull((Object)runnable, "Runnable must not be null");
        if (!this.hasValue()) {
            runnable.run();
        }
    }

    public Optional<V> optional() {
        return Optional.ofNullable(this.value);
    }

    public Stream<V> stream() {
        if (this.hasValue()) {
            return Stream.of(this.value);
        }
        return Stream.empty();
    }
}

