/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.Consumer;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;

public class XAutoClaimArgs<K>
implements CompositeArgument {
    private Consumer<K> consumer;
    private long minIdleTime;
    private String startId;
    private Long count;
    private boolean justid;

    public XAutoClaimArgs<K> consumer(Consumer<K> consumer) {
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        this.consumer = consumer;
        return this;
    }

    public XAutoClaimArgs<K> count(long count) {
        this.count = count;
        return this;
    }

    public XAutoClaimArgs<K> justid() {
        this.justid = true;
        return this;
    }

    public XAutoClaimArgs<K> minIdleTime(long milliseconds) {
        this.minIdleTime = milliseconds;
        return this;
    }

    public XAutoClaimArgs<K> minIdleTime(Duration minIdleTime) {
        LettuceAssert.notNull((Object)minIdleTime, "Min idle time must not be null");
        return this.minIdleTime(minIdleTime.toMillis());
    }

    public XAutoClaimArgs<K> startId(String startId) {
        LettuceAssert.notNull((Object)startId, "StartId must not be null");
        this.startId = startId;
        return this;
    }

    public boolean isJustid() {
        return this.justid;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        args.addKey(this.consumer.getGroup());
        args.addKey(this.consumer.getName());
        args.add(this.minIdleTime);
        args.add(this.startId);
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
        if (this.justid) {
            args.add(CommandKeyword.JUSTID);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> XAutoClaimArgs<K> justid(Consumer<K> consumer, long minIdleTime, String startId) {
            return new XAutoClaimArgs().justid().consumer(consumer).minIdleTime(minIdleTime).startId(startId);
        }

        public static <K> XAutoClaimArgs<K> justid(Consumer<K> consumer, Duration minIdleTime, String startId) {
            return new XAutoClaimArgs().justid().consumer(consumer).minIdleTime(minIdleTime).startId(startId);
        }

        public static <K> XAutoClaimArgs<K> xautoclaim(Consumer<K> consumer, long minIdleTime, String startId) {
            return new XAutoClaimArgs<K>().consumer(consumer).minIdleTime(minIdleTime).startId(startId);
        }

        public static <K> XAutoClaimArgs<K> xautoclaim(Consumer<K> consumer, Duration minIdleTime, String startId) {
            return new XAutoClaimArgs<K>().consumer(consumer).minIdleTime(minIdleTime).startId(startId);
        }
    }
}

