/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.Consumer;
import de.themoep.connectorplugin.lib.lettuce.core.Limit;
import de.themoep.connectorplugin.lib.lettuce.core.Range;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;

public class XPendingArgs<K>
implements CompositeArgument {
    private Consumer<K> consumer;
    private Range<String> range;
    private Limit limit;
    private Long idle;

    public XPendingArgs<K> range(Range<String> range) {
        LettuceAssert.notNull(range, "Range must not be null");
        this.range = range;
        return this;
    }

    public XPendingArgs<K> consumer(Consumer<K> consumer) {
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        this.consumer = consumer;
        return this;
    }

    public XPendingArgs<K> limit(Limit limit) {
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        this.limit = limit;
        return this;
    }

    public XPendingArgs<K> idle(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        return this.idle(timeout.toMillis());
    }

    public XPendingArgs<K> idle(long milliseconds) {
        this.idle = milliseconds;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        args.addKey(this.consumer.group);
        if (this.idle != null) {
            args.add(CommandKeyword.IDLE).add(this.idle);
        }
        if (this.range.getLower().equals(Range.Boundary.unbounded())) {
            args.add("-");
        } else {
            args.add(this.range.getLower().getValue());
        }
        if (this.range.getUpper().equals(Range.Boundary.unbounded())) {
            args.add("+");
        } else {
            args.add(this.range.getUpper().getValue());
        }
        args.add(this.limit.isLimited() ? this.limit.getCount() : Long.MAX_VALUE);
        args.addKey(this.consumer.name);
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> XPendingArgs<K> xpending(Consumer<K> consumer, Range<String> range, Limit limit) {
            return new XPendingArgs<K>().consumer(consumer).range(range).limit(limit);
        }
    }
}

