/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterNodeConnectionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.PooledClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.Partitions;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.net.SocketAddress;

abstract class AbstractClusterNodeConnectionFactory<K, V>
implements ClusterNodeConnectionFactory<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.DefaultClusterNodeConnectionFactory.class);
    private final ClientResources clientResources;
    private volatile Partitions partitions;

    public AbstractClusterNodeConnectionFactory(ClientResources clientResources) {
        this.clientResources = clientResources;
    }

    @Override
    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    Mono<SocketAddress> getSocketAddressSupplier(ClusterNodeConnectionFactory.ConnectionKey connectionKey) {
        return Mono.fromCallable(() -> {
            if (connectionKey.nodeId != null) {
                SocketAddress socketAddress = this.getSocketAddress(connectionKey.nodeId);
                logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)socketAddress, (Object)connectionKey.nodeId);
                return socketAddress;
            }
            SocketAddress socketAddress = this.resolve(RedisURI.create(connectionKey.host, connectionKey.port));
            logger.debug("Resolved SocketAddress {} using for Cluster node at {}:{}", socketAddress, connectionKey.host, connectionKey.port);
            return socketAddress;
        });
    }

    private SocketAddress getSocketAddress(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return this.resolve(partition.getUri());
        }
        throw new IllegalArgumentException(String.format("Cannot resolve a RedisClusterNode for nodeId %s", nodeId));
    }

    private SocketAddress resolve(RedisURI redisURI) {
        return this.clientResources.socketAddressResolver().resolve(redisURI);
    }
}

