/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.NodeSelectionSupport;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

abstract class AbstractNodeSelection<API, CMD, K, V>
implements NodeSelectionSupport<API, CMD> {
    AbstractNodeSelection() {
    }

    @Override
    public Map<RedisClusterNode, API> asMap() {
        ArrayList<RedisClusterNode> list = new ArrayList<RedisClusterNode>(this.nodes());
        HashMap map = new HashMap(list.size(), 1.0f);
        list.forEach(key -> map.put(key, this.getApi((RedisClusterNode)key).join()));
        return map;
    }

    @Override
    public int size() {
        return this.nodes().size();
    }

    @Override
    public RedisClusterNode node(int index) {
        return this.nodes().get(index);
    }

    @Override
    public CMD commands() {
        return null;
    }

    @Override
    public API commands(int index) {
        return this.getApi(this.node(index)).join();
    }

    protected Map<RedisClusterNode, CompletableFuture<? extends StatefulRedisConnection<K, V>>> statefulMap() {
        return this.nodes().stream().collect(Collectors.toMap(redisClusterNode -> redisClusterNode, this::getConnection));
    }

    protected abstract CompletableFuture<? extends StatefulRedisConnection<K, V>> getConnection(RedisClusterNode var1);

    protected abstract CompletableFuture<API> getApi(RedisClusterNode var1);

    protected abstract List<RedisClusterNode> nodes();
}

