/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandWrapper;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ProtocolKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.netty.buffer.ByteBuf;

class ClusterCommand<K, V, T>
extends CommandWrapper<K, V, T>
implements RedisCommand<K, V, T> {
    private int redirections;
    private final int maxRedirections;
    private final RedisChannelWriter retry;
    private boolean completed;

    ClusterCommand(RedisCommand<K, V, T> command, RedisChannelWriter retry, int maxRedirections) {
        super(command);
        this.retry = retry;
        this.maxRedirections = maxRedirections;
    }

    @Override
    public void complete() {
        if (this.isMoved() || this.isAsk()) {
            boolean retryCommand = this.maxRedirections > this.redirections;
            ++this.redirections;
            if (retryCommand) {
                try {
                    this.retry.write(this);
                }
                catch (Exception e) {
                    this.completeExceptionally(e);
                }
                return;
            }
        }
        super.complete();
        this.completed = true;
    }

    public boolean isMoved() {
        return this.getError() != null && this.getError().startsWith(CommandKeyword.MOVED.name());
    }

    public boolean isAsk() {
        return this.getError() != null && this.getError().startsWith(CommandKeyword.ASK.name());
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean result = this.command.completeExceptionally(ex);
        this.completed = true;
        return result;
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isDone() {
        return this.isCompleted();
    }

    public String getError() {
        if (this.command.getOutput() != null) {
            return this.command.getOutput().getError();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [command=").append(this.command);
        sb.append(", redirections=").append(this.redirections);
        sb.append(", maxRedirections=").append(this.maxRedirections);
        sb.append(']');
        return sb.toString();
    }
}

