/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.ClientOptions;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.RedisException;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.DefaultEndpoint;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;

class ClusterNodeEndpoint
extends DefaultEndpoint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeEndpoint.class);
    private final RedisChannelWriter clusterChannelWriter;

    public ClusterNodeEndpoint(ClientOptions clientOptions, ClientResources clientResources, RedisChannelWriter clusterChannelWriter) {
        super(clientOptions, clientResources);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            this.retriggerCommands(this.doExclusive(this::drainCommands));
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }
}

