/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.AbstractRedisAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.GeoArgs;
import de.themoep.connectorplugin.lib.lettuce.core.GeoWithin;
import de.themoep.connectorplugin.lib.lettuce.core.KeyScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.KeyValue;
import de.themoep.connectorplugin.lib.lettuce.core.RedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.ScanArgs;
import de.themoep.connectorplugin.lib.lettuce.core.ScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.StreamScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.api.async.RedisKeyAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.api.async.RedisScriptingAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.api.async.RedisServerAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AbstractNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AsyncClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterDistributionChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterScanSupport;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.DynamicNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.MultiNodeExecution;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.NodeSelectionInvocationHandler;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.PipelinedRedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.SlotHash;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.StatefulRedisClusterConnectionImpl;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.StaticNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.NodeSelectionSupport;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.async.AsyncNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.async.NodeSelectionAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.Partitions;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.output.IntegerOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.KeyStreamingChannel;
import de.themoep.connectorplugin.lib.lettuce.core.output.KeyValueStreamingChannel;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.AsyncCommand;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.Command;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class RedisAdvancedClusterAsyncCommandsImpl<K, V>
extends AbstractRedisAsyncCommands<K, V>
implements RedisAdvancedClusterAsyncCommands<K, V> {
    private final RedisCodec<K, V> codec;

    @Deprecated
    public RedisAdvancedClusterAsyncCommandsImpl(StatefulRedisClusterConnectionImpl<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
    }

    public RedisAdvancedClusterAsyncCommandsImpl(StatefulRedisClusterConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
    }

    @Override
    public RedisFuture<String> clientSetname(K name) {
        HashMap<String, CompletionStage> executions = new HashMap<String, CompletionStage>();
        CompletableFuture<String> ok = CompletableFuture.completedFuture("OK");
        executions.put("Default", super.clientSetname(name).toCompletableFuture());
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            RedisURI uri = redisClusterNode.getUri();
            CompletableFuture<RedisClusterAsyncCommands<K, V>> byNodeId = this.getConnectionAsync(redisClusterNode.getNodeId());
            executions.put("NodeId: " + redisClusterNode.getNodeId(), byNodeId.thenCompose(c -> {
                if (c.isOpen()) {
                    return c.clientSetname(name);
                }
                return ok;
            }));
            CompletableFuture<RedisClusterAsyncCommands<K, V>> byHost = this.getConnectionAsync(uri.getHost(), uri.getPort());
            executions.put("HostAndPort: " + redisClusterNode.getNodeId(), byHost.thenCompose(c -> {
                if (c.isOpen()) {
                    return c.clientSetname(name);
                }
                return ok;
            }));
        }
        return MultiNodeExecution.firstOfAsync(executions);
    }

    @Override
    public RedisFuture<Long> clusterCountKeysInSlot(int slot) {
        RedisClusterAsyncCommands<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterCountKeysInSlot(slot);
        }
        return super.clusterCountKeysInSlot(slot);
    }

    @Override
    public RedisFuture<List<K>> clusterGetKeysInSlot(int slot, int count) {
        RedisClusterAsyncCommands<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterGetKeysInSlot(slot, count);
        }
        return super.clusterGetKeysInSlot(slot, count);
    }

    @Override
    public RedisFuture<Long> dbsize() {
        return MultiNodeExecution.aggregateAsync(this.executeOnUpstream(RedisServerAsyncCommands::dbsize));
    }

    @Override
    public RedisFuture<Long> del(K ... keys) {
        return this.del((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> del(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.del(keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture<Long> del = super.del((Iterable)entry.getValue());
            executions.put(entry.getKey(), del);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<Long> exists(K ... keys) {
        return this.exists((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> exists(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.exists(keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture<Long> exists = super.exists((Iterable)entry.getValue());
            executions.put(entry.getKey(), exists);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<String> flushall() {
        return MultiNodeExecution.firstOfAsync(this.executeOnUpstream(RedisServerAsyncCommands::flushall));
    }

    @Override
    public RedisFuture<String> flushallAsync() {
        return MultiNodeExecution.firstOfAsync(this.executeOnUpstream(RedisServerAsyncCommands::flushallAsync));
    }

    @Override
    public RedisFuture<String> flushdb() {
        return MultiNodeExecution.firstOfAsync(this.executeOnUpstream(RedisServerAsyncCommands::flushdb));
    }

    @Override
    public RedisFuture<Set<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return super.georadius_ro(key, longitude, latitude, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadius_ro(key, longitude, latitude, distance, unit, geoArgs);
    }

    @Override
    public RedisFuture<Set<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return super.georadiusbymember_ro(key, member, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadiusbymember_ro(key, member, distance, unit, geoArgs);
    }

    @Override
    public RedisFuture<List<K>> keys(K pattern) {
        Map executions = this.executeOnUpstream(commands -> commands.keys(pattern));
        return new PipelinedRedisFuture<List<K>>(executions, objectPipelinedRedisFuture -> {
            ArrayList result = new ArrayList();
            for (CompletableFuture future : executions.values()) {
                result.addAll(MultiNodeExecution.execute(future::get));
            }
            return result;
        });
    }

    @Override
    public RedisFuture<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        Map executions = this.executeOnUpstream(commands -> commands.keys(channel, pattern));
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> mget(K ... keys) {
        return this.mget((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> mget(Iterable<K> keys) {
        Map partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.mget(keys);
        }
        Map slots = SlotHash.getSlots(partitioned);
        HashMap executions = new HashMap();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture mget = super.mget((Iterable)entry.getValue());
            executions.put(entry.getKey(), mget);
        }
        return new PipelinedRedisFuture<List<KeyValue<K, V>>>(executions, objectPipelinedRedisFuture -> {
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            for (Object opKey : keys) {
                int slot = (Integer)slots.get(opKey);
                int position = ((List)partitioned.get(slot)).indexOf(opKey);
                RedisFuture listRedisFuture = (RedisFuture)executions.get(slot);
                result.add(MultiNodeExecution.execute(() -> (KeyValue)((List)listRedisFuture.get()).get(position)));
            }
            return result;
        });
    }

    @Override
    public RedisFuture<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        return this.mget(channel, (Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.mget(channel, keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture<Long> del = super.mget(channel, (Iterable)entry.getValue());
            executions.put(entry.getKey(), del);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<String> mset(Map<K, V> map) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, map.keySet());
        if (partitioned.size() < 2) {
            return super.mset(map);
        }
        HashMap<Integer, RedisFuture<String>> executions = new HashMap<Integer, RedisFuture<String>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            HashMap op = new HashMap();
            entry.getValue().forEach(k -> op.put(k, map.get(k)));
            RedisFuture<String> mset = super.mset(op);
            executions.put(entry.getKey(), mset);
        }
        return MultiNodeExecution.firstOfAsync(executions);
    }

    @Override
    public RedisFuture<Boolean> msetnx(Map<K, V> map) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, map.keySet());
        if (partitioned.size() < 2) {
            return super.msetnx(map);
        }
        HashMap<Integer, RedisFuture<Boolean>> executions = new HashMap<Integer, RedisFuture<Boolean>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            HashMap op = new HashMap();
            entry.getValue().forEach(k -> op.put(k, map.get(k)));
            RedisFuture<Boolean> msetnx = super.msetnx(op);
            executions.put(entry.getKey(), msetnx);
        }
        return new PipelinedRedisFuture<Boolean>(executions, objectPipelinedRedisFuture -> {
            for (RedisFuture listRedisFuture : executions.values()) {
                Boolean b = MultiNodeExecution.execute(() -> (Boolean)listRedisFuture.get());
                if (b != null && b.booleanValue()) continue;
                return false;
            }
            return !executions.isEmpty();
        });
    }

    @Override
    public RedisFuture<K> randomkey() {
        Partitions partitions = this.getStatefulConnection().getPartitions();
        int index = ThreadLocalRandom.current().nextInt(partitions.size());
        RedisClusterNode partition = partitions.getPartition(index);
        CompletionStage future = this.getConnectionAsync(partition.getUri().getHost(), partition.getUri().getPort()).thenCompose(RedisKeyAsyncCommands::randomkey);
        return new PipelinedRedisFuture(future);
    }

    @Override
    public RedisFuture<String> scriptFlush() {
        Map executions = this.executeOnNodes(RedisScriptingAsyncCommands::scriptFlush, redisClusterNode -> true);
        return MultiNodeExecution.firstOfAsync(executions);
    }

    @Override
    public RedisFuture<String> scriptKill() {
        Map executions = this.executeOnNodes(RedisScriptingAsyncCommands::scriptKill, redisClusterNode -> true);
        return MultiNodeExecution.alwaysOkOfAsync(executions);
    }

    @Override
    public RedisFuture<String> scriptLoad(byte[] script) {
        Map executions = this.executeOnNodes(cmd -> cmd.scriptLoad(script), redisClusterNode -> true);
        return MultiNodeExecution.lastOfAsync(executions);
    }

    @Override
    public void shutdown(boolean save) {
        this.executeOnNodes(commands -> {
            commands.shutdown(save);
            Command command = new Command(CommandType.SHUTDOWN, new IntegerOutput<K, V>(this.codec), null);
            AsyncCommand async = new AsyncCommand(command);
            async.complete();
            return async;
        }, redisClusterNode -> true);
    }

    @Override
    public RedisFuture<Long> touch(K ... keys) {
        return this.touch((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> touch(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.touch(keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture<Long> touch = super.touch((Iterable)entry.getValue());
            executions.put(entry.getKey(), touch);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<Long> unlink(K ... keys) {
        return this.unlink((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> unlink(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.unlink(keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            RedisFuture<Long> unlink = super.unlink((Iterable)entry.getValue());
            executions.put(entry.getKey(), unlink);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisClusterAsyncCommands<K, V> getConnection(String nodeId) {
        return this.getStatefulConnection().getConnection(nodeId).async();
    }

    @Override
    public RedisClusterAsyncCommands<K, V> getConnection(String host, int port) {
        return this.getStatefulConnection().getConnection(host, port).async();
    }

    private CompletableFuture<RedisClusterAsyncCommands<K, V>> getConnectionAsync(String nodeId) {
        return this.getConnectionProvider().getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, nodeId).thenApply(StatefulRedisConnection::async);
    }

    private CompletableFuture<RedisClusterAsyncCommands<K, V>> getConnectionAsync(String host, int port) {
        return this.getConnectionProvider().getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, host, port).thenApply(StatefulRedisConnection::async);
    }

    @Override
    public StatefulRedisClusterConnection<K, V> getStatefulConnection() {
        return (StatefulRedisClusterConnection)super.getConnection();
    }

    @Override
    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate) {
        return this.nodes(predicate, false);
    }

    @Override
    public AsyncNodeSelection<K, V> readonly(Predicate<RedisClusterNode> predicate) {
        return this.nodes(predicate, ClusterConnectionProvider.Intent.READ, false);
    }

    @Override
    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate, boolean dynamic) {
        return this.nodes(predicate, ClusterConnectionProvider.Intent.WRITE, dynamic);
    }

    protected AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate, ClusterConnectionProvider.Intent intent, boolean dynamic) {
        StatefulRedisClusterConnectionImpl impl = (StatefulRedisClusterConnectionImpl)this.getConnection();
        AbstractNodeSelection selection = dynamic ? new DynamicNodeSelection(impl.getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::async) : new StaticNodeSelection(impl.getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::async);
        NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler((AbstractNodeSelection)selection, RedisClusterAsyncCommands.class, NodeSelectionInvocationHandler.ExecutionModel.ASYNC);
        return (AsyncNodeSelection)Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{NodeSelectionAsyncCommands.class, AsyncNodeSelection.class}, (InvocationHandler)h);
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan() {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(), ClusterScanSupport.asyncClusterKeyScanCursorMapper());
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(scanArgs), ClusterScanSupport.asyncClusterKeyScanCursorMapper());
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan((ScanCursor)cursor, scanArgs), ClusterScanSupport.asyncClusterKeyScanCursorMapper());
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, RedisKeyAsyncCommands::scan, ClusterScanSupport.asyncClusterKeyScanCursorMapper());
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel), ClusterScanSupport.asyncClusterStreamScanCursorMapper());
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel, scanArgs), ClusterScanSupport.asyncClusterStreamScanCursorMapper());
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor, scanArgs), ClusterScanSupport.asyncClusterStreamScanCursorMapper());
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor), ClusterScanSupport.asyncClusterStreamScanCursorMapper());
    }

    private <T extends ScanCursor> RedisFuture<T> clusterScan(ScanCursor cursor, BiFunction<RedisKeyAsyncCommands<K, V>, ScanCursor, RedisFuture<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<RedisFuture<T>> resultMapper) {
        return RedisAdvancedClusterAsyncCommandsImpl.clusterScan(this.getStatefulConnection(), cursor, scanFunction, resultMapper);
    }

    protected <T> Map<String, CompletableFuture<T>> executeOnUpstream(Function<RedisClusterAsyncCommands<K, V>, RedisFuture<T>> function) {
        return this.executeOnNodes(function, redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    protected <T> Map<String, CompletableFuture<T>> executeOnNodes(Function<RedisClusterAsyncCommands<K, V>, RedisFuture<T>> function, Function<RedisClusterNode, Boolean> filter) {
        HashMap<String, CompletableFuture<T>> executions = new HashMap<String, CompletableFuture<T>>();
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            if (!filter.apply(redisClusterNode).booleanValue()) continue;
            RedisURI uri = redisClusterNode.getUri();
            CompletableFuture<RedisClusterAsyncCommands<K, V>> connection = this.getConnectionAsync(uri.getHost(), uri.getPort());
            executions.put(redisClusterNode.getNodeId(), (CompletableFuture<T>)connection.thenCompose(function::apply));
        }
        return executions;
    }

    private RedisClusterAsyncCommands<K, V> findConnectionBySlot(int slot) {
        RedisClusterNode node = this.getStatefulConnection().getPartitions().getPartitionBySlot(slot);
        if (node != null) {
            return this.getConnection(node.getUri().getHost(), node.getUri().getPort());
        }
        return null;
    }

    private AsyncClusterConnectionProvider getConnectionProvider() {
        ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)this.getStatefulConnection().getChannelWriter();
        return (AsyncClusterConnectionProvider)((Object)writer.getClusterConnectionProvider());
    }

    static <T extends ScanCursor, K, V> RedisFuture<T> clusterScan(StatefulRedisClusterConnection<K, V> connection, ScanCursor cursor, BiFunction<RedisKeyAsyncCommands<K, V>, ScanCursor, RedisFuture<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<RedisFuture<T>> mapper) {
        List<String> nodeIds = ClusterScanSupport.getNodeIds(connection, cursor);
        String currentNodeId = ClusterScanSupport.getCurrentNodeId(cursor, nodeIds);
        ScanCursor continuationCursor = ClusterScanSupport.getContinuationCursor(cursor);
        RedisFuture<T> scanCursor = scanFunction.apply(connection.getConnection(currentNodeId).async(), continuationCursor);
        return mapper.map(nodeIds, currentNodeId, scanCursor);
    }
}

