/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.GeoArgs;
import de.themoep.connectorplugin.lib.lettuce.core.GeoWithin;
import de.themoep.connectorplugin.lib.lettuce.core.RedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AbstractNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AsyncClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterDistributionChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.NodeSelectionInvocationHandler;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.StatefulRedisClusterPubSubConnectionImpl;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.NodeSelectionSupport;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.async.NodeSelectionPubSubAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.async.PubSubAsyncNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.async.RedisClusterPubSubAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RedisClusterPubSubAsyncCommandsImpl<K, V>
extends RedisPubSubAsyncCommandsImpl<K, V>
implements RedisClusterPubSubAsyncCommands<K, V> {
    public RedisClusterPubSubAsyncCommandsImpl(StatefulRedisPubSubConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
    }

    @Override
    public RedisFuture<Set<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return super.georadius_ro(key, longitude, latitude, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadius_ro(key, longitude, latitude, distance, unit, geoArgs);
    }

    @Override
    public RedisFuture<Set<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return super.georadiusbymember_ro(key, member, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadiusbymember_ro(key, member, distance, unit, geoArgs);
    }

    @Override
    public StatefulRedisClusterPubSubConnectionImpl<K, V> getStatefulConnection() {
        return (StatefulRedisClusterPubSubConnectionImpl)super.getStatefulConnection();
    }

    @Override
    public PubSubAsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate) {
        StaticPubSubAsyncNodeSelection selection = new StaticPubSubAsyncNodeSelection(this.getStatefulConnection(), predicate);
        NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler((AbstractNodeSelection)selection, RedisPubSubAsyncCommands.class, NodeSelectionInvocationHandler.ExecutionModel.ASYNC);
        return (PubSubAsyncNodeSelection)Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{NodeSelectionPubSubAsyncCommands.class, PubSubAsyncNodeSelection.class}, (InvocationHandler)h);
    }

    private static class StaticPubSubAsyncNodeSelection<K, V>
    extends AbstractNodeSelection<RedisPubSubAsyncCommands<K, V>, NodeSelectionPubSubAsyncCommands<K, V>, K, V>
    implements PubSubAsyncNodeSelection<K, V> {
        private final List<RedisClusterNode> redisClusterNodes;
        private final ClusterDistributionChannelWriter writer;

        public StaticPubSubAsyncNodeSelection(StatefulRedisClusterPubSubConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector) {
            this.redisClusterNodes = globalConnection.getPartitions().stream().filter(selector).collect(Collectors.toList());
            this.writer = ((StatefulRedisClusterPubSubConnectionImpl)globalConnection).getClusterDistributionChannelWriter();
        }

        @Override
        protected CompletableFuture<RedisPubSubAsyncCommands<K, V>> getApi(RedisClusterNode redisClusterNode) {
            return this.getConnection(redisClusterNode).thenApply(StatefulRedisPubSubConnection::async);
        }

        @Override
        protected List<RedisClusterNode> nodes() {
            return this.redisClusterNodes;
        }

        @Override
        protected CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnection(RedisClusterNode redisClusterNode) {
            RedisURI uri = redisClusterNode.getUri();
            AsyncClusterConnectionProvider async = (AsyncClusterConnectionProvider)((Object)this.writer.getClusterConnectionProvider());
            return async.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, uri.getHost(), uri.getPort()).thenApply(it -> (StatefulRedisPubSubConnection)it);
        }
    }
}

