/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.internal.HostAndPort;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public abstract class RedisClusterURIUtil {
    private RedisClusterURIUtil() {
    }

    public static List<RedisURI> toRedisURIs(URI uri) {
        RedisURI redisURI = RedisURI.create(uri);
        String[] parts = redisURI.getHost().split("\\,");
        ArrayList<RedisURI> redisURIs = new ArrayList<RedisURI>(parts.length);
        for (String part : parts) {
            HostAndPort hostAndPort = HostAndPort.parse(part);
            RedisURI nodeUri = RedisURI.create(hostAndPort.getHostText(), hostAndPort.hasPort() ? hostAndPort.getPort() : redisURI.getPort());
            RedisClusterURIUtil.applyUriConnectionSettings(redisURI, nodeUri);
            redisURIs.add(nodeUri);
        }
        return redisURIs;
    }

    static void applyUriConnectionSettings(RedisURI from, RedisURI to) {
        to.applyAuthentication(from);
        to.applySsl(from);
        to.setTimeout(from.getTimeout());
    }
}

