/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.AbstractRedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.ClientOptions;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.RedisException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AsyncClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterClientOptions;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterDistributionChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterFutureSyncInvocationHandler;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterPushHandler;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.PubSubClusterEndpoint;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.RedisClusterPubSubAsyncCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.RedisClusterPubSubReactiveCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.api.push.RedisClusterPushListener;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.Partitions;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.RedisClusterPubSubListener;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.async.RedisClusterPubSubAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.reactive.RedisClusterPubSubReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.sync.NodeSelectionPubSubCommands;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.sync.PubSubNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.pubsub.api.sync.RedisClusterPubSubCommands;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.StatefulRedisPubSubConnectionImpl;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class StatefulRedisClusterPubSubConnectionImpl<K, V>
extends StatefulRedisPubSubConnectionImpl<K, V>
implements StatefulRedisClusterPubSubConnection<K, V> {
    private final PubSubClusterEndpoint<K, V> endpoint;
    private final ClusterPushHandler clusterPushHandler;
    private volatile Partitions partitions;
    private volatile String nodeId;

    public StatefulRedisClusterPubSubConnectionImpl(PubSubClusterEndpoint<K, V> endpoint, ClusterPushHandler clusterPushHandler, RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(endpoint, writer, codec, timeout);
        this.endpoint = endpoint;
        this.clusterPushHandler = clusterPushHandler;
    }

    @Override
    public RedisClusterPubSubAsyncCommands<K, V> async() {
        return (RedisClusterPubSubAsyncCommands)super.async();
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisClusterPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisClusterPubSubCommands<K, V> sync() {
        return (RedisClusterPubSubCommands)super.sync();
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), new Class[]{RedisClusterPubSubCommands.class, RedisPubSubCommands.class}, this.syncInvocationHandler());
    }

    private InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, RedisPubSubAsyncCommands.class, PubSubNodeSelection.class, NodeSelectionPubSubCommands.class, this.async());
    }

    @Override
    public RedisClusterPubSubReactiveCommands<K, V> reactive() {
        return (RedisClusterPubSubReactiveCommands)super.reactive();
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisClusterPubSubReactiveCommandsImpl(this, this.codec);
    }

    @Override
    protected List<RedisFuture<Void>> resubscribe() {
        this.async().clusterMyId().thenAccept(nodeId -> this.endpoint.setClusterNode(this.partitions.getPartitionByNodeId((String)nodeId)));
        return super.resubscribe();
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getConnection(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return (StatefulRedisPubSubConnection)this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnectionAsync(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getConnection(String host, int port) {
        return (StatefulRedisPubSubConnection)this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    @Override
    public CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnectionAsync(String host, int port) {
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    @Override
    public void activated() {
        super.activated();
        this.async.clusterMyId().thenAccept(this::setNodeId);
    }

    public void setPartitions(Partitions partitions) {
        LettuceAssert.notNull((Object)partitions, "Partitions must not be null");
        this.partitions = partitions;
        String nodeId = this.getNodeId();
        if (nodeId != null && this.expireStaleConnections() && partitions.getPartitionByNodeId(nodeId) == null) {
            this.endpoint.disconnect();
        }
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    private String getNodeId() {
        return this.nodeId;
    }

    private void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setNodeMessagePropagation(boolean enabled) {
        this.endpoint.setNodeMessagePropagation(enabled);
    }

    @Override
    public void addListener(RedisClusterPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisClusterPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    @Override
    public void addListener(RedisClusterPushListener listener) {
        this.clusterPushHandler.addListener(listener);
    }

    @Override
    public void removeListener(RedisClusterPushListener listener) {
        this.clusterPushHandler.removeListener(listener);
    }

    protected ClusterDistributionChannelWriter getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }

    private boolean expireStaleConnections() {
        ClusterClientOptions options = this.getClusterClientOptions();
        return options == null || options.isCloseStaleConnections();
    }

    private ClusterClientOptions getClusterClientOptions() {
        ClientOptions options = this.getOptions();
        return options instanceof ClusterClientOptions ? (ClusterClientOptions)options : null;
    }
}

