/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AbstractNodeSelection;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.AsyncClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.ClusterDistributionChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class StaticNodeSelection<API, CMD, K, V>
extends AbstractNodeSelection<API, CMD, K, V> {
    private final ClusterDistributionChannelWriter writer;
    private final ClusterConnectionProvider.Intent intent;
    private final List<RedisClusterNode> redisClusterNodes;
    private final Function<StatefulRedisConnection<K, V>, API> apiExtractor;

    public StaticNodeSelection(ClusterDistributionChannelWriter writer, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent, Function<StatefulRedisConnection<K, V>, API> apiExtractor) {
        this.writer = writer;
        this.intent = intent;
        this.apiExtractor = apiExtractor;
        this.redisClusterNodes = writer.getPartitions().stream().filter(selector).collect(Collectors.toList());
    }

    @Override
    protected CompletableFuture<StatefulRedisConnection<K, V>> getConnection(RedisClusterNode redisClusterNode) {
        RedisURI uri = redisClusterNode.getUri();
        AsyncClusterConnectionProvider async = (AsyncClusterConnectionProvider)((Object)this.writer.getClusterConnectionProvider());
        return async.getConnectionAsync(this.intent, uri.getHost(), uri.getPort());
    }

    @Override
    protected CompletableFuture<API> getApi(RedisClusterNode redisClusterNode) {
        return this.getConnection(redisClusterNode).thenApply(this.apiExtractor);
    }

    @Override
    protected List<RedisClusterNode> nodes() {
        return this.redisClusterNodes;
    }
}

