/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.cluster.topology;

import de.themoep.connectorplugin.lib.lettuce.core.RedisFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.ClusterPartitionParser;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.Partitions;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.models.partitions.RedisClusterNode;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.topology.Requests;
import de.themoep.connectorplugin.lib.lettuce.core.cluster.topology.TimedAsyncCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NodeTopologyView {
    private static final Pattern NUMBER = Pattern.compile("(\\d+)");
    private final boolean available;
    private final RedisURI redisURI;
    private Partitions partitions;
    private final int connectedClients;
    private final long latency;
    private final String clusterNodes;
    private final String clientList;

    private NodeTopologyView(RedisURI redisURI) {
        this.available = false;
        this.redisURI = redisURI;
        this.partitions = new Partitions();
        this.connectedClients = 0;
        this.clusterNodes = null;
        this.clientList = null;
        this.latency = 0L;
    }

    NodeTopologyView(RedisURI redisURI, String clusterNodes, String clientList2, long latency) {
        this.available = true;
        this.redisURI = redisURI;
        this.partitions = ClusterPartitionParser.parse(clusterNodes);
        this.connectedClients = clientList2 != null ? this.getClients(clientList2) : 0;
        this.clusterNodes = clusterNodes;
        this.clientList = clientList2;
        this.latency = latency;
    }

    static NodeTopologyView from(RedisURI redisURI, Requests clusterNodesRequests, Requests clientListRequests) {
        TimedAsyncCommand<String, String, String> nodes = clusterNodesRequests.getRequest(redisURI);
        TimedAsyncCommand<String, String, String> clients = clientListRequests.getRequest(redisURI);
        if (NodeTopologyView.resultAvailable(nodes) && NodeTopologyView.resultAvailable(clients)) {
            return new NodeTopologyView(redisURI, (String)nodes.join(), NodeTopologyView.optionallyGet(clients), nodes.duration());
        }
        return new NodeTopologyView(redisURI);
    }

    private static <T> T optionallyGet(TimedAsyncCommand<?, ?, T> command) {
        if (command.isCompletedExceptionally()) {
            return null;
        }
        return command.join();
    }

    private static boolean resultAvailable(RedisFuture<?> redisFuture) {
        return redisFuture != null && redisFuture.isDone() && !redisFuture.isCancelled();
    }

    private int getClients(String rawClientsOutput) {
        String[] rows;
        for (String row : rows = rawClientsOutput.trim().split("\\n")) {
            Matcher matcher = NUMBER.matcher(row);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    long getLatency() {
        return this.latency;
    }

    boolean isAvailable() {
        return this.available;
    }

    Partitions getPartitions() {
        return this.partitions;
    }

    int getConnectedClients() {
        return this.connectedClients;
    }

    String getNodeId() {
        return this.getOwnPartition().getNodeId();
    }

    RedisURI getRedisURI() {
        if (this.partitions.isEmpty()) {
            return this.redisURI;
        }
        return this.getOwnPartition().getUri();
    }

    RedisClusterNode getOwnPartition() {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.is(RedisClusterNode.NodeFlag.MYSELF)) continue;
            return partition;
        }
        throw new IllegalStateException("Cannot determine own partition");
    }

    String getClientList() {
        return this.clientList;
    }

    String getClusterNodes() {
        return this.clusterNodes;
    }

    void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }
}

