/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.codec;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.ToByteBufEncoder;
import de.themoep.connectorplugin.lib.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

public class ByteArrayCodec
implements RedisCodec<byte[], byte[]>,
ToByteBufEncoder<byte[], byte[]> {
    public static final ByteArrayCodec INSTANCE = new ByteArrayCodec();
    private static final byte[] EMPTY = new byte[0];

    @Override
    public void encodeKey(byte[] key, ByteBuf target) {
        if (key != null) {
            target.writeBytes(key);
        }
    }

    @Override
    public void encodeValue(byte[] value, ByteBuf target) {
        this.encodeKey(value, target);
    }

    @Override
    public int estimateSize(Object keyOrValue) {
        if (keyOrValue == null) {
            return 0;
        }
        return ((byte[])keyOrValue).length;
    }

    @Override
    public byte[] decodeKey(ByteBuffer bytes) {
        return ByteArrayCodec.getBytes(bytes);
    }

    @Override
    public byte[] decodeValue(ByteBuffer bytes) {
        return ByteArrayCodec.getBytes(bytes);
    }

    @Override
    public ByteBuffer encodeKey(byte[] key) {
        if (key == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        return ByteBuffer.wrap(key);
    }

    @Override
    public ByteBuffer encodeValue(byte[] value) {
        return this.encodeKey(value);
    }

    private static byte[] getBytes(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return EMPTY;
        }
        byte[] b = new byte[remaining];
        buffer.get(b);
        return b;
    }
}

