/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.codec;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.ToByteBufEncoder;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class CipherCodec {
    private CipherCodec() {
    }

    public static <K, V> RedisCodec<K, V> forValues(RedisCodec<K, V> delegate, CipherSupplier encrypt, CipherSupplier decrypt) {
        LettuceAssert.notNull(delegate, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)encrypt, "Encryption Supplier must not be null");
        LettuceAssert.notNull((Object)decrypt, "Decryption Supplier must not be null");
        return new CipherCodecWrapper(delegate, encrypt, decrypt);
    }

    public static class KeyDescriptor {
        private static final KeyDescriptor UNNAMED = new KeyDescriptor("".getBytes(StandardCharsets.US_ASCII), 0);
        private final byte[] name;
        private final int version;

        private KeyDescriptor(byte[] name, int version) {
            for (byte b : name) {
                if (b != 43 && b != 36) continue;
                throw new IllegalArgumentException(String.format("Key name %s must not contain plus (+) or dollar ($) characters", new String(name)));
            }
            this.name = name;
            this.version = version;
        }

        public static KeyDescriptor unnamed() {
            return UNNAMED;
        }

        public static KeyDescriptor create(String name) {
            return KeyDescriptor.create(name, 0);
        }

        public static KeyDescriptor create(String name, int version) {
            return KeyDescriptor.create(name, version, Charset.defaultCharset());
        }

        public static KeyDescriptor create(String name, int version, Charset charset) {
            LettuceAssert.notNull((Object)name, "Name must not be null");
            LettuceAssert.notNull((Object)charset, "Charset must not be null");
            return new KeyDescriptor(name.getBytes(charset), version);
        }

        static KeyDescriptor from(ByteBuffer bytes) {
            int end = -1;
            int version = -1;
            if (bytes.get() != 36) {
                throw new IllegalArgumentException("Cannot extract KeyDescriptor. Malformed message header.");
            }
            int startPosition = bytes.position();
            for (int i = 0; i < bytes.remaining(); ++i) {
                if (bytes.get(bytes.position() + i) == 36) {
                    end = bytes.position() - startPosition + i;
                    break;
                }
                if (bytes.get(bytes.position() + i) != 43) continue;
                version = bytes.position() - startPosition + i;
            }
            if (end == -1 || version == -1) {
                throw new IllegalArgumentException("Cannot extract KeyDescriptor");
            }
            byte[] name = new byte[version];
            bytes.get(name);
            bytes.get();
            byte[] versionBytes = new byte[end - version - 1];
            bytes.get(versionBytes);
            bytes.get();
            return new KeyDescriptor(name, Integer.parseInt(new String(versionBytes)));
        }

        public int getVersion() {
            return this.version;
        }

        public String getName() {
            return this.getName(Charset.defaultCharset());
        }

        public String getName(Charset charset) {
            LettuceAssert.notNull((Object)charset, "Charset must not be null");
            return new String(this.name, charset);
        }

        void writeTo(ByteBuf target) {
            target.writeByte(36).writeBytes(this.name).writeByte(43).writeBytes(Integer.toString(this.version).getBytes()).writeByte(36);
        }

        void writeTo(ByteBuffer target) {
            target.put((byte)36).put(this.name).put((byte)43).put(Integer.toString(this.version).getBytes()).put((byte)36);
        }
    }

    @FunctionalInterface
    public static interface CipherSupplier {
        public Cipher get(KeyDescriptor var1) throws GeneralSecurityException;

        default public KeyDescriptor encryptionKey() {
            return KeyDescriptor.unnamed();
        }
    }

    private static class CipherCodecWrapper
    implements RedisCodec<Object, Object>,
    ToByteBufEncoder<Object, Object> {
        private RedisCodec<Object, Object> delegate;
        private CipherSupplier encrypt;
        private CipherSupplier decrypt;

        CipherCodecWrapper(RedisCodec<Object, Object> delegate, CipherSupplier encrypt, CipherSupplier decrypt) {
            this.delegate = delegate;
            this.encrypt = encrypt;
            this.decrypt = decrypt;
        }

        @Override
        public Object decodeKey(ByteBuffer bytes) {
            return this.delegate.decodeKey(bytes);
        }

        @Override
        public Object decodeValue(ByteBuffer bytes) {
            KeyDescriptor keyDescriptor = KeyDescriptor.from(bytes);
            try {
                return this.delegate.decodeValue(this.doWithCipher(this.decrypt.get(keyDescriptor), bytes));
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void encodeKey(Object key, ByteBuf target) {
            if (this.delegate instanceof ToByteBufEncoder) {
                ((ToByteBufEncoder)((Object)this.delegate)).encodeKey(key, target);
                return;
            }
            target.writeBytes(this.delegate.encodeKey(key));
        }

        @Override
        public void encodeValue(Object value, ByteBuf target) {
            ByteBuf serialized;
            if (this.delegate instanceof ToByteBufEncoder) {
                serialized = target.alloc().buffer(this.estimateSize(value));
                ((ToByteBufEncoder)((Object)this.delegate)).encodeKey(value, serialized);
            } else {
                ByteBuffer byteBuffer = this.delegate.encodeValue(value);
                serialized = target.alloc().buffer(byteBuffer.remaining());
                serialized.writeBytes(byteBuffer);
            }
            try {
                KeyDescriptor keyDescriptor = this.encrypt.encryptionKey();
                Cipher cipher = this.encrypt.get(keyDescriptor);
                keyDescriptor.writeTo(target);
                this.doWithCipher(cipher, serialized, target);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
            finally {
                serialized.release();
            }
        }

        @Override
        public int estimateSize(Object keyOrValue) {
            if (this.delegate instanceof ToByteBufEncoder) {
                return ((ToByteBufEncoder)((Object)this.delegate)).estimateSize(keyOrValue);
            }
            return 24;
        }

        @Override
        public ByteBuffer encodeKey(Object key) {
            return this.delegate.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(Object value) {
            try {
                ByteBuffer serialized = this.delegate.encodeValue(value);
                KeyDescriptor keyDescriptor = this.encrypt.encryptionKey();
                Cipher cipher = this.encrypt.get(keyDescriptor);
                ByteBuffer intermediate = ByteBuffer.allocate(cipher.getOutputSize(serialized.remaining() + 3 + keyDescriptor.name.length + 10));
                keyDescriptor.writeTo(intermediate);
                intermediate.put(this.doWithCipher(cipher, serialized));
                intermediate.flip();
                return intermediate;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        private void doWithCipher(Cipher cipher, ByteBuf serialized, ByteBuf target) throws GeneralSecurityException {
            ByteBuffer intermediate = ByteBuffer.allocate(cipher.getOutputSize(serialized.readableBytes()));
            ByteBuffer buffer = serialized.nioBuffer();
            cipher.update(buffer, intermediate);
            cipher.doFinal(buffer, intermediate);
            intermediate.flip();
            target.writeBytes(intermediate);
            serialized.readerIndex(serialized.writerIndex());
        }

        private ByteBuffer doWithCipher(Cipher cipher, ByteBuffer source) throws GeneralSecurityException {
            byte[] encrypted = new byte[source.remaining()];
            source.get(encrypted);
            byte[] update = cipher.update(encrypted);
            byte[] finalBytes = cipher.doFinal();
            ByteBuffer buffer = ByteBuffer.allocate(update.length + finalBytes.length);
            buffer.put(update).put(finalBytes).flip();
            return buffer;
        }
    }
}

