/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.codec;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.nio.ByteBuffer;

class ComposedRedisCodec<K, V>
implements RedisCodec<K, V> {
    private final RedisCodec<K, ?> keyCodec;
    private final RedisCodec<?, V> valueCodec;

    ComposedRedisCodec(RedisCodec<K, ?> keyCodec, RedisCodec<?, V> valueCodec) {
        LettuceAssert.notNull(keyCodec, "Key codec must not be null");
        LettuceAssert.notNull(valueCodec, "Value codec must not be null");
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    @Override
    public K decodeKey(ByteBuffer bytes) {
        return this.keyCodec.decodeKey(bytes);
    }

    @Override
    public V decodeValue(ByteBuffer bytes) {
        return this.valueCodec.decodeValue(bytes);
    }

    @Override
    public ByteBuffer encodeKey(K key) {
        return this.keyCodec.encodeKey(key);
    }

    @Override
    public ByteBuffer encodeValue(V value) {
        return this.valueCodec.encodeValue(value);
    }
}

