/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulConnection;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.AsyncExecutableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethod;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethodVerifier;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommandLookupStrategySupport;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.RedisCommandsMetadata;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.util.List;

class AsyncExecutableCommandLookupStrategy
extends ExecutableCommandLookupStrategySupport {
    private final StatefulConnection<Object, Object> connection;

    public AsyncExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier, StatefulConnection<Object, Object> connection) {
        super(redisCodecs, commandOutputFactoryResolver, commandMethodVerifier);
        this.connection = connection;
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata metadata) {
        LettuceAssert.isTrue(!method.isReactiveExecution(), () -> String.format("Command method %s not supported by this command lookup strategy", method));
        CommandFactory commandFactory = super.resolveCommandFactory(method, metadata);
        return new AsyncExecutableCommand(method, commandFactory, this.connection);
    }
}

