/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandCreationException;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethod;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethodVerifier;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandSegmentCommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.RedisCommandsMetadata;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.codec.AnnotationRedisCodecResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CodecAwareOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.AnnotationCommandSegmentFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.CommandSegments;
import java.util.List;

abstract class ExecutableCommandLookupStrategySupport
implements ExecutableCommandLookupStrategy {
    private final List<RedisCodec<?, ?>> redisCodecs;
    private final CommandOutputFactoryResolver commandOutputFactoryResolver;
    private final CommandFactoryResolver commandFactoryResolver;
    private final CommandMethodVerifier commandMethodVerifier;

    public ExecutableCommandLookupStrategySupport(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier) {
        this.redisCodecs = redisCodecs;
        this.commandOutputFactoryResolver = commandOutputFactoryResolver;
        this.commandMethodVerifier = commandMethodVerifier;
        this.commandFactoryResolver = new DefaultCommandFactoryResolver();
    }

    protected CommandFactory resolveCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata commandsMetadata) {
        return this.commandFactoryResolver.resolveRedisCommandFactory(commandMethod, commandsMetadata);
    }

    class DefaultCommandFactoryResolver
    implements CommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        DefaultCommandFactoryResolver() {
            this.codecResolver = new AnnotationRedisCodecResolver(ExecutableCommandLookupStrategySupport.this.redisCodecs);
        }

        @Override
        public CommandFactory resolveRedisCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata commandsMetadata) {
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve RedisCodec");
            }
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(ExecutableCommandLookupStrategySupport.this.commandOutputFactoryResolver, codec);
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            ExecutableCommandLookupStrategySupport.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            return new CommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }
}

