/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.GeoCoordinates;
import de.themoep.connectorplugin.lib.lettuce.core.KeyValue;
import de.themoep.connectorplugin.lib.lettuce.core.Limit;
import de.themoep.connectorplugin.lib.lettuce.core.Range;
import de.themoep.connectorplugin.lib.lettuce.core.ScoredValue;
import de.themoep.connectorplugin.lib.lettuce.core.Value;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.parameter.MethodParametersAccessor;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.CommandSegment;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.CommandSegments;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ProtocolKeyword;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

class ParameterBinder {
    private static final byte[] MINUS_BYTES = new byte[]{45};
    private static final byte[] PLUS_BYTES = new byte[]{43};

    ParameterBinder() {
    }

    <K, V> CommandArgs<K, V> bind(CommandArgs<K, V> args, RedisCodec<K, V> codec, CommandSegments commandSegments, MethodParametersAccessor accessor) {
        int parameterCount = accessor.getParameterCount();
        BitSet set2 = new BitSet(parameterCount);
        for (CommandSegment commandSegment : commandSegments) {
            CommandSegment.ArgumentContribution argumentContribution = commandSegment.contribute(accessor);
            this.bind(args, codec, argumentContribution.getValue(), argumentContribution.getParameterIndex(), accessor);
            if (argumentContribution.getParameterIndex() == -1) continue;
            set2.set(argumentContribution.getParameterIndex());
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (set2.get(i)) continue;
            Object bindableValue = accessor.getBindableValue(i);
            this.bind(args, codec, bindableValue, i, accessor);
            set2.set(i);
        }
        return args;
    }

    private <K, V> void bind(CommandArgs<K, V> args, RedisCodec<K, V> codec, Object argument, int index, MethodParametersAccessor accessor) {
        if (argument == null) {
            if (accessor.isBindableNullValue(index)) {
                args.add(new byte[0]);
            }
            return;
        }
        if (argument instanceof byte[]) {
            if (index != -1 && accessor.isKey(index)) {
                args.addKey(argument);
            } else {
                args.add((byte[])argument);
            }
            return;
        }
        if (argument.getClass().isArray()) {
            argument = ParameterBinder.asIterable(argument);
        }
        if (index != -1) {
            if (accessor.isKey(index)) {
                if (argument instanceof Iterable) {
                    args.addKeys((Iterable)argument);
                } else {
                    args.addKey(argument);
                }
                return;
            }
            if (accessor.isValue(index)) {
                if (argument instanceof Range) {
                    ParameterBinder.bindValueRange(args, codec, (Range)argument);
                    return;
                }
                if (argument instanceof Iterable) {
                    args.addValues((Iterable)argument);
                } else {
                    args.addValue(argument);
                }
                return;
            }
        }
        if (argument instanceof Iterable) {
            for (Object argumentElement : (Iterable)argument) {
                ParameterBinder.bindArgument(args, argumentElement);
            }
            return;
        }
        ParameterBinder.bindArgument(args, argument);
    }

    private static <K, V> void bindArgument(CommandArgs<K, V> args, Object argument) {
        if (argument instanceof byte[]) {
            args.add((byte[])argument);
            return;
        }
        if (argument instanceof String) {
            args.add((String)argument);
            return;
        }
        if (argument instanceof Double) {
            args.add((Double)argument);
            return;
        }
        if (argument instanceof Number) {
            args.add(((Number)argument).longValue());
            return;
        }
        if (argument instanceof ProtocolKeyword) {
            args.add((ProtocolKeyword)argument);
            return;
        }
        if (argument instanceof Map) {
            args.add((Map)argument);
            return;
        }
        if (argument instanceof ScoredValue) {
            ScoredValue scoredValue = (ScoredValue)argument;
            Object value = scoredValue.getValueOrElseThrow(() -> new IllegalArgumentException("Cannot bind empty ScoredValue to a Redis command."));
            args.add(scoredValue.getScore());
            args.addValue(value);
            return;
        }
        if (argument instanceof KeyValue) {
            KeyValue keyValue = (KeyValue)argument;
            Object value = keyValue.getValueOrElseThrow(() -> new IllegalArgumentException("Cannot bind empty KeyValue to a Redis command."));
            args.addKey(keyValue.getKey());
            args.addValue(value);
            return;
        }
        if (argument instanceof Value) {
            Value valueWrapper = (Value)argument;
            Object value = valueWrapper.getValueOrElseThrow(() -> new IllegalArgumentException("Cannot bind empty Value to a Redis command."));
            args.addValue(value);
            return;
        }
        if (argument instanceof Limit) {
            Limit limit = (Limit)argument;
            args.add(CommandKeyword.LIMIT);
            args.add(limit.getOffset());
            args.add(limit.getCount());
            return;
        }
        if (argument instanceof Range) {
            Range range = (Range)argument;
            ParameterBinder.bindNumericRange(args, range);
            return;
        }
        if (argument instanceof GeoCoordinates) {
            GeoCoordinates coordinates = (GeoCoordinates)argument;
            args.add(coordinates.getX().doubleValue());
            args.add(coordinates.getY().doubleValue());
            return;
        }
        if (argument instanceof CompositeArgument) {
            ((CompositeArgument)argument).build(args);
            return;
        }
        throw new IllegalArgumentException("Cannot bind unsupported command argument " + args);
    }

    private static <K, V> void bindValueRange(CommandArgs<K, V> args, RedisCodec<K, V> codec, Range<? extends V> range) {
        args.add(ParameterBinder.minValue(codec, range));
        args.add(ParameterBinder.maxValue(codec, range));
    }

    private static <K, V> void bindNumericRange(CommandArgs<K, V> args, Range<? extends Number> range) {
        if (range.getLower().getValue() != null && !(range.getLower().getValue() instanceof Number)) {
            throw new IllegalArgumentException("Cannot bind non-numeric lower range value for a numeric Range. Annotate with @Value if the Range contains a value range.");
        }
        if (range.getUpper().getValue() != null && !(range.getUpper().getValue() instanceof Number)) {
            throw new IllegalArgumentException("Cannot bind non-numeric upper range value for a numeric Range. Annotate with @Value if the Range contains a value range.");
        }
        args.add(ParameterBinder.minNumeric(range));
        args.add(ParameterBinder.maxNumeric(range));
    }

    private static String minNumeric(Range<? extends Number> range) {
        Range.Boundary<? extends Number> lower = range.getLower();
        if (lower.getValue() == null || lower.getValue() instanceof Double && lower.getValue().doubleValue() == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (!lower.isIncluding()) {
            return "(" + lower.getValue();
        }
        return lower.getValue().toString();
    }

    private static String maxNumeric(Range<? extends Number> range) {
        Range.Boundary<? extends Number> upper = range.getUpper();
        if (upper.getValue() == null || upper.getValue() instanceof Double && upper.getValue().doubleValue() == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (!upper.isIncluding()) {
            return "(" + upper.getValue();
        }
        return upper.getValue().toString();
    }

    private static <K, V> byte[] minValue(RedisCodec<K, V> codec, Range<? extends V> range) {
        return ParameterBinder.valueRange(range.getLower(), MINUS_BYTES, codec);
    }

    private static <K, V> byte[] maxValue(RedisCodec<K, V> codec, Range<? extends V> range) {
        return ParameterBinder.valueRange(range.getUpper(), PLUS_BYTES, codec);
    }

    private static <K, V> byte[] valueRange(Range.Boundary<? extends V> boundary, byte[] unbounded, RedisCodec<K, V> codec) {
        if (boundary.getValue() == null) {
            return unbounded;
        }
        ByteBuffer encodeValue = codec.encodeValue(boundary.getValue());
        byte[] argument = new byte[encodeValue.remaining() + 1];
        argument[0] = (byte)(boundary.isIncluding() ? 91 : 40);
        encodeValue.get(argument, 1, argument.length - 1);
        return argument;
    }

    private static Object asIterable(Object argument) {
        if (argument.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(argument);
            ArrayList<Object> elements = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                elements.add(Array.get(argument, i));
            }
            return elements;
        }
        return Arrays.asList((Object[])argument);
    }
}

