/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandCreationException;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethod;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandSegmentCommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveTypes;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.OutputSelector;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.CommandSegments;

class ReactiveCommandSegmentCommandFactory
extends CommandSegmentCommandFactory {
    private boolean streamingExecution;

    ReactiveCommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<?, ?> redisCodec, CommandOutputFactoryResolver outputResolver) {
        super(commandSegments, commandMethod, redisCodec, outputResolver);
        ExecutionSpecificParameters executionAwareParameters;
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex()) {
            throw new CommandCreationException(commandMethod, "Reactive command methods do not support Timeout parameters");
        }
    }

    @Override
    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        this.streamingExecution = ReactiveTypes.isMultiValueType(outputSelector.getOutputType().getRawClass());
        OutputSelector componentType = new OutputSelector(outputSelector.getOutputType().getGeneric(0), outputSelector.getRedisCodec());
        if (this.streamingExecution) {
            CommandOutputFactory streamingFactory = this.getOutputResolver().resolveStreamingCommandOutput(componentType);
            if (this.streamingExecution && streamingFactory != null) {
                return streamingFactory;
            }
        }
        return super.resolveCommandOutputFactory(componentType);
    }

    boolean isStreamingExecution() {
        return this.streamingExecution;
    }
}

