/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.AbstractRedisReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethod;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveCommandSegmentCommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveTypes;

class ReactiveExecutableCommand
implements ExecutableCommand {
    private final CommandMethod commandMethod;
    private final ReactiveCommandSegmentCommandFactory commandFactory;
    private final AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands;

    ReactiveExecutableCommand(CommandMethod commandMethod, ReactiveCommandSegmentCommandFactory commandFactory, AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands) {
        this.commandMethod = commandMethod;
        this.commandFactory = commandFactory;
        this.redisReactiveCommands = redisReactiveCommands;
    }

    @Override
    public Object execute(Object[] parameters) {
        return this.dispatch(parameters);
    }

    protected Object dispatch(Object[] arguments) {
        if (ReactiveTypes.isSingleValueType(this.commandMethod.getReturnType().getRawClass())) {
            return this.redisReactiveCommands.createMono(() -> this.commandFactory.createCommand(arguments));
        }
        if (this.commandFactory.isStreamingExecution()) {
            return this.redisReactiveCommands.createDissolvingFlux(() -> this.commandFactory.createCommand(arguments));
        }
        return this.redisReactiveCommands.createFlux(() -> this.commandFactory.createCommand(arguments));
    }

    @Override
    public CommandMethod getCommandMethod() {
        return this.commandMethod;
    }
}

