/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.AbstractRedisReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandCreationException;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethod;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.CommandMethodVerifier;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ConversionService;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ConvertingCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveCommandSegmentCommandFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveExecutableCommand;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.ReactiveTypeAdapters;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.RedisCommandsMetadata;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.codec.AnnotationRedisCodecResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CodecAwareOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.AnnotationCommandSegmentFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.segment.CommandSegments;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.util.List;

class ReactiveExecutableCommandLookupStrategy
implements ExecutableCommandLookupStrategy {
    private final AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands;
    private final ConversionService conversionService = new ConversionService();
    private final List<RedisCodec<?, ?>> redisCodecs;
    private final CommandOutputFactoryResolver outputFactoryResolver;
    private final ReactiveCommandFactoryResolver commandFactoryResolver;
    private final CommandMethodVerifier commandMethodVerifier;

    ReactiveExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver outputFactoryResolver, CommandMethodVerifier commandMethodVerifier, AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands) {
        this.redisReactiveCommands = redisReactiveCommands;
        this.redisCodecs = redisCodecs;
        this.outputFactoryResolver = outputFactoryResolver;
        this.commandMethodVerifier = commandMethodVerifier;
        ReactiveTypeAdapters.registerIn(this.conversionService);
        this.commandFactoryResolver = new ReactiveCommandFactoryResolver();
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata commandsMetadata) {
        LettuceAssert.isTrue(!method.isBatchExecution(), () -> String.format("Command batching %s not supported with ReactiveExecutableCommandLookupStrategy", method));
        LettuceAssert.isTrue(method.isReactiveExecution(), () -> String.format("Command method %s not supported by ReactiveExecutableCommandLookupStrategy", method));
        ReactiveCommandSegmentCommandFactory commandFactory = this.commandFactoryResolver.resolveRedisCommandFactory(method, commandsMetadata);
        return new ConvertingCommand(this.conversionService, new ReactiveExecutableCommand(method, commandFactory, this.redisReactiveCommands));
    }

    class ReactiveCommandFactoryResolver
    implements CommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        ReactiveCommandFactoryResolver() {
            this.codecResolver = new AnnotationRedisCodecResolver(ReactiveExecutableCommandLookupStrategy.this.redisCodecs);
        }

        @Override
        public ReactiveCommandSegmentCommandFactory resolveRedisCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata redisCommandsMetadata) {
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve RedisCodec");
            }
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            ReactiveExecutableCommandLookupStrategy.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(ReactiveExecutableCommandLookupStrategy.this.outputFactoryResolver, codec);
            return new ReactiveCommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }
}

