/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceClassUtils;
import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import io.reactivex.Maybe;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import rx.Observable;

class ReactiveTypes {
    private static final boolean PROJECT_REACTOR_PRESENT = LettuceClassUtils.isPresent("de.themoep.connectorplugin.lib.reactor.core.publisher.Mono");
    private static final boolean RXJAVA1_PRESENT = LettuceClassUtils.isPresent("rx.Completable");
    private static final boolean RXJAVA2_PRESENT = LettuceClassUtils.isPresent("io.reactivex.Flowable");
    private static final boolean RXJAVA3_PRESENT = LettuceClassUtils.isPresent("io.reactivex.rxjava3.core.Flowable");
    private static final Map<Class<?>, Descriptor> REACTIVE_WRAPPERS;

    ReactiveTypes() {
    }

    public static boolean isAvailable() {
        return ReactiveTypes.isAvailable(ReactiveLibrary.PROJECT_REACTOR) || ReactiveTypes.isAvailable(ReactiveLibrary.RXJAVA1) || ReactiveTypes.isAvailable(ReactiveLibrary.RXJAVA2) || ReactiveTypes.isAvailable(ReactiveLibrary.RXJAVA3);
    }

    public static boolean isAvailable(ReactiveLibrary reactiveLibrary) {
        LettuceAssert.notNull((Object)reactiveLibrary, "ReactiveLibrary must not be null!");
        switch (reactiveLibrary) {
            case PROJECT_REACTOR: {
                return PROJECT_REACTOR_PRESENT;
            }
            case RXJAVA1: {
                return RXJAVA1_PRESENT;
            }
            case RXJAVA2: {
                return RXJAVA2_PRESENT;
            }
            case RXJAVA3: {
                return RXJAVA3_PRESENT;
            }
        }
        throw new IllegalArgumentException(String.format("ReactiveLibrary %s not supported", new Object[]{reactiveLibrary}));
    }

    public static boolean supports(Class<?> type) {
        return ReactiveTypes.isNoValueType(type) || ReactiveTypes.isSingleValueType(type) || ReactiveTypes.isMultiValueType(type);
    }

    public static boolean isNoValueType(Class<?> type) {
        LettuceAssert.notNull(type, "Class must not be null!");
        return ReactiveTypes.findDescriptor(type).map(Descriptor::isNoValue).orElse(false);
    }

    public static boolean isSingleValueType(Class<?> type) {
        LettuceAssert.notNull(type, "Class must not be null!");
        return ReactiveTypes.findDescriptor(type).map(descriptor -> !descriptor.isMultiValue() && !descriptor.isNoValue()).orElse(false);
    }

    public static boolean isMultiValueType(Class<?> type) {
        LettuceAssert.notNull(type, "Class must not be null!");
        if (ReactiveTypes.isSingleValueType(type)) {
            return false;
        }
        return ReactiveTypes.findDescriptor(type).map(Descriptor::isMultiValue).orElse(false);
    }

    public static Collection<Class<?>> getNoValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> ((Descriptor)entry.getValue()).isNoValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getSingleValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> !((Descriptor)entry.getValue()).isMultiValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getMultiValueTypes() {
        return REACTIVE_WRAPPERS.entrySet().stream().filter(entry -> ((Descriptor)entry.getValue()).isMultiValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static Optional<Descriptor> findDescriptor(Class<?> rhsType) {
        for (Class<?> type : REACTIVE_WRAPPERS.keySet()) {
            if (!LettuceClassUtils.isAssignable(type, rhsType)) continue;
            return Optional.ofNullable(REACTIVE_WRAPPERS.get(type));
        }
        return Optional.empty();
    }

    static {
        LinkedHashMap<Class, Descriptor> reactiveWrappers = new LinkedHashMap<Class, Descriptor>(3);
        if (RXJAVA1_PRESENT) {
            reactiveWrappers.put(rx.Single.class, new Descriptor(false, true, false));
            reactiveWrappers.put(rx.Completable.class, new Descriptor(false, true, true));
            reactiveWrappers.put(Observable.class, new Descriptor(true, true, false));
        }
        if (RXJAVA2_PRESENT) {
            reactiveWrappers.put(io.reactivex.Single.class, new Descriptor(false, true, false));
            reactiveWrappers.put(Maybe.class, new Descriptor(false, true, false));
            reactiveWrappers.put(io.reactivex.Completable.class, new Descriptor(false, true, true));
            reactiveWrappers.put(io.reactivex.Flowable.class, new Descriptor(true, true, false));
            reactiveWrappers.put(io.reactivex.Observable.class, new Descriptor(true, true, false));
        }
        if (RXJAVA3_PRESENT) {
            reactiveWrappers.put(Single.class, new Descriptor(false, true, false));
            reactiveWrappers.put(io.reactivex.rxjava3.core.Maybe.class, new Descriptor(false, true, false));
            reactiveWrappers.put(Completable.class, new Descriptor(false, true, true));
            reactiveWrappers.put(Flowable.class, new Descriptor(true, true, false));
            reactiveWrappers.put(io.reactivex.rxjava3.core.Observable.class, new Descriptor(true, true, false));
        }
        if (PROJECT_REACTOR_PRESENT) {
            reactiveWrappers.put(Mono.class, new Descriptor(false, true, false));
            reactiveWrappers.put(Flux.class, new Descriptor(true, true, true));
            reactiveWrappers.put(Publisher.class, new Descriptor(true, true, true));
        }
        REACTIVE_WRAPPERS = Collections.unmodifiableMap(reactiveWrappers);
    }

    public static class Descriptor {
        private final boolean isMultiValue;
        private final boolean supportsEmpty;
        private final boolean isNoValue;

        public Descriptor(boolean isMultiValue, boolean canBeEmpty, boolean isNoValue) {
            this.isMultiValue = isMultiValue;
            this.supportsEmpty = canBeEmpty;
            this.isNoValue = isNoValue;
        }

        public boolean isMultiValue() {
            return this.isMultiValue;
        }

        public boolean supportsEmpty() {
            return this.supportsEmpty;
        }

        public boolean isNoValue() {
            return this.isNoValue;
        }
    }

    static enum ReactiveLibrary {
        PROJECT_REACTOR,
        RXJAVA1,
        RXJAVA2,
        RXJAVA3;

    }
}

