/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic.intercept;

import de.themoep.connectorplugin.lib.lettuce.core.dynamic.intercept.InvocationTargetProvider;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.intercept.MethodInterceptor;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.intercept.MethodInvocation;
import de.themoep.connectorplugin.lib.lettuce.core.internal.DefaultMethods;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultMethodInvokingInterceptor
implements MethodInterceptor {
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentHashMap<Method, MethodHandle>();

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isDefault()) {
            return invocation.proceed();
        }
        LettuceAssert.isTrue(invocation instanceof InvocationTargetProvider, "Invocation must provide a target object via InvocationTargetProvider");
        InvocationTargetProvider targetProvider = (InvocationTargetProvider)((Object)invocation);
        return this.methodHandleCache.computeIfAbsent(method, DefaultMethodInvokingInterceptor::lookupMethodHandle).bindTo(targetProvider.getInvocationTarget()).invokeWithArguments(invocation.getArguments());
    }

    private static MethodHandle lookupMethodHandle(Method method) {
        try {
            return DefaultMethods.lookupMethodHandle(method);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

