/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.dynamic.output;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.CommandOutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.output.OutputType;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.support.ClassTypeInformation;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.support.ResolvableType;
import de.themoep.connectorplugin.lib.lettuce.core.dynamic.support.TypeInformation;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.ArrayOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.BooleanListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.BooleanOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ByteArrayOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.DoubleOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.GeoCoordinatesListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.GeoCoordinatesValueListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.IntegerOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.KeyListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.KeyOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListOfMapsOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.MapOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ScoredValueListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.StringListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.StringValueListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ValueListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ValueOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ValueSetOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ValueValueListOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.VoidOutput;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OutputRegistry {
    private static final Map<OutputType, CommandOutputFactory> BUILTIN = new LinkedHashMap<OutputType, CommandOutputFactory>();
    private final Map<OutputType, CommandOutputFactory> registry = new LinkedHashMap<OutputType, CommandOutputFactory>();

    public OutputRegistry() {
        this(true);
    }

    public OutputRegistry(boolean registerBuiltin) {
        if (registerBuiltin) {
            this.registry.putAll(BUILTIN);
        }
    }

    public <T extends CommandOutput<?, ?, ?>> void register(Class<T> commandOutputClass, CommandOutputFactory commandOutputFactory) {
        LettuceAssert.notNull(commandOutputClass, "CommandOutput class must not be null");
        LettuceAssert.notNull((Object)commandOutputFactory, "CommandOutputFactory must not be null");
        OutputRegistry.register(this.registry, commandOutputClass, commandOutputFactory);
    }

    Map<OutputType, CommandOutputFactory> getRegistry() {
        return this.registry;
    }

    private static <T extends CommandOutput<?, ?, ?>> void register(Map<OutputType, CommandOutputFactory> registry, Class<T> commandOutputClass, CommandOutputFactory commandOutputFactory) {
        List<OutputType> outputTypes = OutputRegistry.getOutputTypes(commandOutputClass);
        for (OutputType outputType : outputTypes) {
            registry.put(outputType, commandOutputFactory);
        }
    }

    private static List<OutputType> getOutputTypes(Class<? extends CommandOutput<?, ?, ?>> commandOutputClass) {
        OutputType streamingType = OutputRegistry.getStreamingType(commandOutputClass);
        OutputType componentOutputType = OutputRegistry.getOutputComponentType(commandOutputClass);
        ArrayList<OutputType> types = new ArrayList<OutputType>(2);
        if (streamingType != null) {
            types.add(streamingType);
        }
        if (componentOutputType != null) {
            types.add(componentOutputType);
        }
        return types;
    }

    static OutputType getStreamingType(final Class<? extends CommandOutput> commandOutputClass) {
        ClassTypeInformation<? extends CommandOutput> classTypeInformation = ClassTypeInformation.from(commandOutputClass);
        TypeInformation superTypeInformation = classTypeInformation.getSuperTypeInformation((Class)StreamingOutput.class);
        if (superTypeInformation == null) {
            return null;
        }
        List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
        return new OutputType(commandOutputClass, typeArguments.get(0), true){

            @Override
            public ResolvableType withCodec(RedisCodec<?, ?> codec) {
                ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(codec.getClass());
                for (ResolvableType resolvableType = ResolvableType.forType((Type)commandOutputClass, new CodecVariableTypeResolver(typeInformation)); resolvableType != ResolvableType.NONE; resolvableType = resolvableType.getSuperType()) {
                    ResolvableType[] interfaces;
                    for (ResolvableType resolvableInterface : interfaces = resolvableType.getInterfaces()) {
                        if (!resolvableInterface.getRawClass().equals(StreamingOutput.class)) continue;
                        return resolvableInterface.getGeneric(0);
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    static OutputType getOutputComponentType(final Class<? extends CommandOutput> commandOutputClass) {
        ClassTypeInformation<? extends CommandOutput> classTypeInformation = ClassTypeInformation.from(commandOutputClass);
        TypeInformation superTypeInformation = classTypeInformation.getSuperTypeInformation((Class)CommandOutput.class);
        if (superTypeInformation == null) {
            return null;
        }
        List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
        return new OutputType(commandOutputClass, typeArguments.get(2), false){

            @Override
            public ResolvableType withCodec(RedisCodec<?, ?> codec) {
                ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(codec.getClass());
                ResolvableType resolvableType = ResolvableType.forType((Type)commandOutputClass, new CodecVariableTypeResolver(typeInformation));
                while (!resolvableType.getRawClass().equals(CommandOutput.class)) {
                    resolvableType = resolvableType.getSuperType();
                }
                return resolvableType.getGeneric(2);
            }
        };
    }

    static {
        LinkedHashMap<OutputType, CommandOutputFactory> registry = new LinkedHashMap<OutputType, CommandOutputFactory>();
        OutputRegistry.register(registry, ListOfMapsOutput.class, ListOfMapsOutput::new);
        OutputRegistry.register(registry, ArrayOutput.class, ArrayOutput::new);
        OutputRegistry.register(registry, DoubleOutput.class, DoubleOutput::new);
        OutputRegistry.register(registry, ByteArrayOutput.class, ByteArrayOutput::new);
        OutputRegistry.register(registry, IntegerOutput.class, IntegerOutput::new);
        OutputRegistry.register(registry, KeyOutput.class, KeyOutput::new);
        OutputRegistry.register(registry, ValueOutput.class, ValueOutput::new);
        OutputRegistry.register(registry, KeyListOutput.class, KeyListOutput::new);
        OutputRegistry.register(registry, ValueListOutput.class, ValueListOutput::new);
        OutputRegistry.register(registry, MapOutput.class, MapOutput::new);
        OutputRegistry.register(registry, ValueSetOutput.class, ValueSetOutput::new);
        OutputRegistry.register(registry, BooleanOutput.class, BooleanOutput::new);
        OutputRegistry.register(registry, BooleanListOutput.class, BooleanListOutput::new);
        OutputRegistry.register(registry, GeoCoordinatesListOutput.class, GeoCoordinatesListOutput::new);
        OutputRegistry.register(registry, GeoCoordinatesValueListOutput.class, GeoCoordinatesValueListOutput::new);
        OutputRegistry.register(registry, ScoredValueListOutput.class, ScoredValueListOutput::new);
        OutputRegistry.register(registry, ValueValueListOutput.class, ValueValueListOutput::new);
        OutputRegistry.register(registry, StringValueListOutput.class, StringValueListOutput::new);
        OutputRegistry.register(registry, StringListOutput.class, StringListOutput::new);
        OutputRegistry.register(registry, VoidOutput.class, VoidOutput::new);
        BUILTIN.putAll(registry);
    }

    static class CodecVariableTypeResolver
    implements ResolvableType.VariableResolver {
        private final TypeInformation<?> codecType;
        private final List<TypeInformation<?>> typeArguments;

        public CodecVariableTypeResolver(TypeInformation<?> codecType) {
            this.codecType = codecType.getSuperTypeInformation(RedisCodec.class);
            this.typeArguments = this.codecType.getTypeArguments();
        }

        @Override
        public Object getSource() {
            return this.codecType;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            if (variable.getName().equals("K")) {
                return ResolvableType.forClass(this.typeArguments.get(0).getType());
            }
            if (variable.getName().equals("V")) {
                return ResolvableType.forClass(this.typeArguments.get(1).getType());
            }
            return null;
        }
    }
}

