/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.event;

import de.themoep.connectorplugin.lib.lettuce.core.event.Event;
import de.themoep.connectorplugin.lib.lettuce.core.event.EventBus;
import de.themoep.connectorplugin.lib.lettuce.core.event.jfr.EventRecorder;
import de.themoep.connectorplugin.lib.reactor.core.publisher.DirectProcessor;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.FluxSink;
import de.themoep.connectorplugin.lib.reactor.core.scheduler.Scheduler;

public class DefaultEventBus
implements EventBus {
    private final DirectProcessor<Event> bus;
    private final FluxSink<Event> sink;
    private final Scheduler scheduler;
    private final EventRecorder recorder = EventRecorder.getInstance();

    public DefaultEventBus(Scheduler scheduler) {
        this.bus = DirectProcessor.create();
        this.sink = this.bus.sink();
        this.scheduler = scheduler;
    }

    @Override
    public Flux<Event> get() {
        return this.bus.onBackpressureDrop().publishOn(this.scheduler);
    }

    @Override
    public void publish(Event event) {
        this.recorder.record(event);
        this.sink.next(event);
    }
}

