/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.event;

import de.themoep.connectorplugin.lib.lettuce.core.event.EventPublisherOptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultEventPublisherOptions
implements EventPublisherOptions {
    public static final long DEFAULT_EMIT_INTERVAL = 10L;
    public static final TimeUnit DEFAULT_EMIT_INTERVAL_UNIT = TimeUnit.MINUTES;
    public static final Duration DEFAULT_EMIT_INTERVAL_DURATION = Duration.ofMinutes(10L);
    private static final DefaultEventPublisherOptions DISABLED = new Builder().eventEmitInterval(Duration.ZERO).build();
    private final Duration eventEmitInterval;

    private DefaultEventPublisherOptions(Builder builder) {
        this.eventEmitInterval = builder.eventEmitInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Duration eventEmitInterval() {
        return this.eventEmitInterval;
    }

    public static DefaultEventPublisherOptions create() {
        return new Builder().build();
    }

    public static DefaultEventPublisherOptions disabled() {
        return DISABLED;
    }

    public static class Builder {
        private Duration eventEmitInterval = DEFAULT_EMIT_INTERVAL_DURATION;

        private Builder() {
        }

        public Builder eventEmitInterval(Duration eventEmitInterval) {
            LettuceAssert.notNull((Object)eventEmitInterval, "EventEmitInterval must not be null");
            LettuceAssert.isTrue(!eventEmitInterval.isNegative(), "EventEmitInterval must be greater or equal to 0");
            this.eventEmitInterval = eventEmitInterval;
            return this;
        }

        @Deprecated
        public Builder eventEmitInterval(long eventEmitInterval, TimeUnit eventEmitIntervalUnit) {
            LettuceAssert.isTrue(eventEmitInterval >= 0L, "EventEmitInterval must be greater or equal to 0");
            LettuceAssert.notNull((Object)eventEmitIntervalUnit, "EventEmitIntervalUnit must not be null");
            return this.eventEmitInterval(Duration.ofNanos(eventEmitIntervalUnit.toNanos(eventEmitInterval)));
        }

        public DefaultEventPublisherOptions build() {
            return new DefaultEventPublisherOptions(this);
        }
    }
}

