/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.event.connection;

import de.themoep.connectorplugin.lib.lettuce.core.event.connection.ConnectionEvent;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.net.SocketAddress;

abstract class ConnectionEventSupport
implements ConnectionEvent {
    private final String redisUri;
    private final String epId;
    private final String channelId;
    private final SocketAddress local;
    private final SocketAddress remote;

    ConnectionEventSupport(SocketAddress local, SocketAddress remote) {
        this(null, null, null, local, remote);
    }

    ConnectionEventSupport(String redisUri, String epId, String channelId, SocketAddress local, SocketAddress remote) {
        LettuceAssert.notNull((Object)local, "Local must not be null");
        LettuceAssert.notNull((Object)remote, "Remote must not be null");
        this.redisUri = redisUri;
        this.epId = epId;
        this.channelId = channelId;
        this.local = local;
        this.remote = remote;
    }

    @Override
    public SocketAddress localAddress() {
        return this.local;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remote;
    }

    String getRedisUri() {
        return this.redisUri;
    }

    String getEpId() {
        return this.epId;
    }

    String getChannelId() {
        return this.channelId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.local);
        sb.append(" -> ").append(this.remote);
        sb.append(']');
        return sb.toString();
    }
}

