/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.event.metrics;

import de.themoep.connectorplugin.lib.lettuce.core.event.EventBus;
import de.themoep.connectorplugin.lib.lettuce.core.event.EventPublisherOptions;
import de.themoep.connectorplugin.lib.lettuce.core.event.metrics.CommandLatencyEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.metrics.MetricEventPublisher;
import de.themoep.connectorplugin.lib.lettuce.core.metrics.CommandLatencyCollector;
import de.themoep.connectorplugin.lib.netty.util.concurrent.EventExecutorGroup;
import de.themoep.connectorplugin.lib.netty.util.concurrent.ScheduledFuture;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultCommandLatencyEventPublisher
implements MetricEventPublisher {
    private final EventExecutorGroup eventExecutorGroup;
    private final EventPublisherOptions options;
    private final EventBus eventBus;
    private final CommandLatencyCollector commandLatencyCollector;
    private final Runnable EMITTER = this::emitMetricsEvent;
    private volatile ScheduledFuture<?> scheduledFuture;

    public DefaultCommandLatencyEventPublisher(EventExecutorGroup eventExecutorGroup, EventPublisherOptions options, EventBus eventBus, CommandLatencyCollector commandLatencyCollector) {
        this.eventExecutorGroup = eventExecutorGroup;
        this.options = options;
        this.eventBus = eventBus;
        this.commandLatencyCollector = commandLatencyCollector;
        if (!options.eventEmitInterval().isZero()) {
            this.scheduledFuture = this.eventExecutorGroup.scheduleAtFixedRate(this.EMITTER, options.eventEmitInterval().toMillis(), options.eventEmitInterval().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.options.eventEmitInterval().isZero() && this.scheduledFuture != null;
    }

    @Override
    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    @Override
    public void emitMetricsEvent() {
        if (!this.isEnabled() || !this.commandLatencyCollector.isEnabled()) {
            return;
        }
        this.eventBus.publish(new CommandLatencyEvent((Map)this.commandLatencyCollector.retrieveMetrics()));
    }
}

