/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null) {
            args = NO_ARGS;
        }
        if (args.length == 0 && method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (args.length == 1 && method.getName().equals("equals") && method.getParameterTypes()[0] == Object.class) {
            Object arg = args[0];
            if (arg == null) {
                return false;
            }
            if (proxy == arg) {
                return true;
            }
            return AbstractInvocationHandler.isProxyOfSameInterfaces(arg, proxy.getClass()) && this.equals(Proxy.getInvocationHandler(arg));
        }
        if (args.length == 0 && method.getName().equals("toString")) {
            return this.toString();
        }
        return this.handleInvocation(proxy, method, args);
    }

    protected abstract Object handleInvocation(Object var1, Method var2, Object[] var3) throws Throwable;

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    private static boolean isProxyOfSameInterfaces(Object arg, Class<?> proxyClass) {
        return proxyClass.isInstance(arg) || Proxy.isProxyClass(arg.getClass()) && Arrays.equals(arg.getClass().getInterfaces(), proxyClass.getInterfaces());
    }

    protected static class MethodTranslator {
        private static final WeakHashMap<Class<?>, MethodTranslator> TRANSLATOR_MAP = new WeakHashMap(32);
        private final Map<Method, Method> map;

        private MethodTranslator(Class<?> delegate, Class<?> ... methodSources) {
            this.map = this.createMethodMap(delegate, methodSources);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static MethodTranslator of(Class<?> delegate, Class<?> ... methodSources) {
            WeakHashMap<Class<?>, MethodTranslator> weakHashMap = TRANSLATOR_MAP;
            synchronized (weakHashMap) {
                return TRANSLATOR_MAP.computeIfAbsent(delegate, key -> new MethodTranslator((Class<?>)key, methodSources));
            }
        }

        private Map<Method, Method> createMethodMap(Class<?> delegate, Class<?>[] methodSources) {
            ArrayList<? extends Method> methods = new ArrayList<Method>();
            for (Class<?> sourceClass : methodSources) {
                methods.addAll(this.getMethods(sourceClass));
            }
            HashMap<Method, Method> map = new HashMap<Method, Method>(methods.size(), 1.0f);
            for (Method method : methods) {
                try {
                    map.put(method, delegate.getMethod(method.getName(), method.getParameterTypes()));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            return map;
        }

        private Collection<? extends Method> getMethods(Class<?> sourceClass) {
            HashSet<Method> result = new HashSet<Method>();
            Class<?> searchType = sourceClass;
            while (searchType != null && searchType != Object.class) {
                result.addAll(this.filterPublicMethods(Arrays.asList(sourceClass.getDeclaredMethods())));
                if (sourceClass.isInterface()) {
                    Class<?>[] interfaces;
                    for (Class<?> interfaceClass : interfaces = sourceClass.getInterfaces()) {
                        result.addAll(this.getMethods(interfaceClass));
                    }
                    searchType = null;
                    continue;
                }
                searchType = searchType.getSuperclass();
            }
            return result;
        }

        private Collection<? extends Method> filterPublicMethods(List<Method> methods) {
            ArrayList<Method> result = new ArrayList<Method>(methods.size());
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                result.add(method);
            }
            return result;
        }

        public Method get(Method key) {
            Method result = this.map.get(key);
            if (result != null) {
                return result;
            }
            throw new IllegalStateException("Cannot find source method " + key);
        }
    }
}

