/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.internal;

import de.themoep.connectorplugin.lib.lettuce.core.TimeoutOptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public class TimeoutProvider {
    private final Supplier<TimeoutOptions> timeoutOptionsSupplier;
    private final LongSupplier defaultTimeoutSupplier;
    private State state;

    public TimeoutProvider(Supplier<TimeoutOptions> timeoutOptionsSupplier, LongSupplier defaultTimeoutNsSupplier) {
        LettuceAssert.notNull(timeoutOptionsSupplier, "TimeoutOptionsSupplier must not be null");
        LettuceAssert.notNull((Object)defaultTimeoutNsSupplier, "Default TimeoutSupplier must not be null");
        this.timeoutOptionsSupplier = timeoutOptionsSupplier;
        this.defaultTimeoutSupplier = defaultTimeoutNsSupplier;
    }

    public long getTimeoutNs(RedisCommand<?, ?, ?> command) {
        long timeoutNs = -1L;
        State state = this.state;
        if (state == null) {
            state = this.state = new State(this.timeoutOptionsSupplier.get());
        }
        if (!state.applyDefaultTimeout) {
            timeoutNs = state.timeoutSource.getTimeUnit().toNanos(state.timeoutSource.getTimeout(command));
        }
        return timeoutNs >= 0L ? timeoutNs : this.defaultTimeoutSupplier.getAsLong();
    }

    static class State {
        final boolean applyDefaultTimeout;
        final TimeoutOptions.TimeoutSource timeoutSource;

        State(TimeoutOptions timeoutOptions) {
            this.timeoutSource = timeoutOptions.getSource();
            this.applyDefaultTimeout = this.timeoutSource == null || !timeoutOptions.isTimeoutCommands() || timeoutOptions.isApplyConnectionTimeout();
        }
    }
}

