/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.Connections;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.ReplicaUtils;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import de.themoep.connectorplugin.lib.reactor.util.function.Tuples;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

class AsyncConnections {
    private final Map<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> connections = new TreeMap<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>>(ReplicaUtils.RedisURIComparator.INSTANCE);
    private final List<RedisNodeDescription> nodeList;

    AsyncConnections(List<RedisNodeDescription> nodeList) {
        this.nodeList = nodeList;
    }

    public void addConnection(RedisURI redisURI, CompletableFuture<StatefulRedisConnection<String, String>> connection) {
        this.connections.put(redisURI, connection);
    }

    public Mono<Connections> asMono(Duration timeout, ScheduledExecutorService timeoutExecutor) {
        Connections connections = new Connections(this.connections.size(), this.nodeList);
        for (Map.Entry<RedisURI, CompletableFuture<StatefulRedisConnection<String, String>>> entry : this.connections.entrySet()) {
            CompletableFuture<StatefulRedisConnection<String, String>> future = entry.getValue();
            future.whenComplete((connection, throwable) -> {
                if (throwable != null) {
                    connections.accept((Throwable)throwable);
                } else {
                    connections.accept(Tuples.of(entry.getKey(), connection));
                }
            });
        }
        return Mono.fromCompletionStage(connections.getOrTimeout(timeout, timeoutExecutor));
    }
}

