/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.AsyncCloseable;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Futures;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.CompletableEventLatchSupport;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.ReplicaUtils;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.Requests;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.TimedAsyncCommand;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.lettuce.core.output.StatusOutput;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.Command;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandType;
import de.themoep.connectorplugin.lib.reactor.util.function.Tuple2;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class Connections
extends CompletableEventLatchSupport<Tuple2<RedisURI, StatefulRedisConnection<String, String>>, Connections>
implements AsyncCloseable {
    private final Lock lock = new ReentrantLock();
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(ReplicaUtils.RedisURIComparator.INSTANCE);
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private final List<RedisNodeDescription> nodes;
    private volatile boolean closed = false;

    public Connections(int expectedConnectionCount, List<RedisNodeDescription> nodes) {
        super(expectedConnectionCount);
        this.nodes = nodes;
    }

    @Override
    protected void onAccept(Tuple2<RedisURI, StatefulRedisConnection<String, String>> value) {
        if (this.closed) {
            value.getT2().closeAsync();
            return;
        }
        try {
            this.lock.lock();
            this.connections.put(value.getT1(), value.getT2());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void onError(Throwable value) {
        this.exceptions.add(value);
    }

    @Override
    protected void onDrop(Tuple2<RedisURI, StatefulRedisConnection<String, String>> value) {
        value.getT2().closeAsync();
    }

    @Override
    protected void onDrop(Throwable value) {
    }

    @Override
    protected void onEmit(CompletableEventLatchSupport.Emission<Connections> emission) {
        if (this.getExpectedCount() != 0 && this.connections.isEmpty() && !this.exceptions.isEmpty()) {
            RedisConnectionException collector = new RedisConnectionException("Unable to establish a connection to Redis Master/Replica");
            this.exceptions.forEach(collector::addSuppressed);
            emission.error(collector);
        } else {
            emission.success(this);
        }
    }

    public boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = this.connections.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Requests requestPing() {
        LinkedHashSet<Map.Entry<RedisURI, StatefulRedisConnection<String, String>>> entries = new LinkedHashSet<Map.Entry<RedisURI, StatefulRedisConnection<String, String>>>(this.connections.entrySet());
        Requests requests = new Requests(entries.size(), this.nodes);
        for (Map.Entry entry : entries) {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.ASCII).add(CommandKeyword.NODES);
            Command command = new Command(CommandType.PING, new StatusOutput<String, String>(StringCodec.ASCII), args);
            TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
            ((StatefulRedisConnection)entry.getValue()).dispatch(timedCommand);
            requests.addRequest((RedisURI)entry.getKey(), timedCommand);
        }
        return requests;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        ArrayList<CompletableFuture<Void>> close = new ArrayList<CompletableFuture<Void>>(this.connections.size());
        ArrayList<RedisURI> toRemove = new ArrayList<RedisURI>(this.connections.size());
        this.closed = true;
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
            toRemove.add(entry.getKey());
            close.add(entry.getValue().closeAsync());
        }
        for (RedisURI redisURI : toRemove) {
            this.connections.remove(redisURI);
        }
        return Futures.allOf(close);
    }
}

