/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.ConnectionFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Futures;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceLists;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.AutodiscoveryConnector;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.SentinelConnector;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.StaticMasterReplicaConnector;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class MasterReplica {
    public static <K, V> StatefulRedisMasterReplicaConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        return MasterReplica.getConnection(MasterReplica.connectAsyncSentinelOrAutodiscovery(redisClient, codec, redisURI), redisURI);
    }

    public static <K, V> CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        return MasterReplica.transformAsyncConnectionException(MasterReplica.connectAsyncSentinelOrAutodiscovery(redisClient, codec, redisURI), redisURI);
    }

    private static <K, V> CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsyncSentinelOrAutodiscovery(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        if (MasterReplica.isSentinel(redisURI)) {
            return new SentinelConnector<K, V>(redisClient, codec, redisURI).connectAsync();
        }
        return new AutodiscoveryConnector<K, V>(redisClient, codec, redisURI).connectAsync();
    }

    public static <K, V> StatefulRedisMasterReplicaConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        return MasterReplica.getConnection(MasterReplica.connectAsyncSentinelOrStaticSetup(redisClient, codec, redisURIs), redisURIs);
    }

    public static <K, V> CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        return MasterReplica.transformAsyncConnectionException(MasterReplica.connectAsyncSentinelOrStaticSetup(redisClient, codec, redisURIs), redisURIs);
    }

    private static <K, V> CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsyncSentinelOrStaticSetup(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        List<RedisURI> uriList = LettuceLists.newList(redisURIs);
        LettuceAssert.isTrue(!uriList.isEmpty(), "RedisURIs must not be empty");
        RedisURI first = uriList.get(0);
        if (MasterReplica.isSentinel(first)) {
            if (uriList.size() > 1) {
                InternalLogger logger = InternalLoggerFactory.getInstance(MasterReplica.class);
                logger.warn("RedisURIs contains multiple endpoints of which the first is configured for Sentinel usage. Using only the first URI [{}] without considering the remaining URIs. Make sure to include all Sentinel endpoints in a single RedisURI.", (Object)first);
            }
            return new SentinelConnector<K, V>(redisClient, codec, first).connectAsync();
        }
        return new StaticMasterReplicaConnector<K, V>(redisClient, codec, uriList).connectAsync();
    }

    private static boolean isSentinel(RedisURI redisURI) {
        return !redisURI.getSentinels().isEmpty();
    }

    private static <T> T getConnection(CompletableFuture<T> connectionFuture, Object context) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(context.toString(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                if (e.getCause() instanceof RedisConnectionException && e.getCause().getCause() instanceof RedisConnectionException) {
                    throw RedisConnectionException.create(context.toString(), e.getCause().getCause());
                }
                throw RedisConnectionException.create(context.toString(), e.getCause());
            }
            throw RedisConnectionException.create(context.toString(), (Throwable)e);
        }
    }

    private static <T> CompletableFuture<T> transformAsyncConnectionException(CompletionStage<T> future, Object context) {
        return ConnectionFuture.from(null, future.toCompletableFuture()).thenCompose((v, e) -> {
            if (e != null) {
                if (e.getCause() instanceof RedisConnectionException && e.getCause().getCause() instanceof RedisConnectionException) {
                    return Futures.failed(RedisConnectionException.create(context.toString(), e.getCause()));
                }
                return Futures.failed(RedisConnectionException.create(context.toString(), e));
            }
            return CompletableFuture.completedFuture(v);
        }).toCompletableFuture();
    }
}

