/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceLists;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.AsyncConnections;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.NodeConnectionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.RedisClientNodeConnectionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.Requests;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.ResumeAfter;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.TopologyProvider;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;

class MasterReplicaTopologyRefresh {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterReplicaTopologyRefresh.class);
    private static final StringCodec CODEC = StringCodec.UTF8;
    private final NodeConnectionFactory nodeConnectionFactory;
    private final TopologyProvider topologyProvider;
    private final ScheduledExecutorService eventExecutors;

    MasterReplicaTopologyRefresh(RedisClient client, TopologyProvider topologyProvider) {
        this(new RedisClientNodeConnectionFactory(client), client.getResources().eventExecutorGroup(), topologyProvider);
    }

    MasterReplicaTopologyRefresh(NodeConnectionFactory nodeConnectionFactory, ScheduledExecutorService eventExecutors, TopologyProvider topologyProvider) {
        this.nodeConnectionFactory = nodeConnectionFactory;
        this.eventExecutors = eventExecutors;
        this.topologyProvider = topologyProvider;
    }

    public Mono<List<RedisNodeDescription>> getNodes(RedisURI seed) {
        CompletableFuture<List<RedisNodeDescription>> future = this.topologyProvider.getNodesAsync();
        Mono<List> initialNodes = Mono.fromFuture(future).doOnNext(nodes -> MasterReplicaTopologyRefresh.applyAuthenticationCredentials(nodes, seed));
        return initialNodes.map(this::getConnections).flatMap(asyncConnections -> asyncConnections.asMono(seed.getTimeout(), this.eventExecutors)).flatMap(connections -> {
            Requests requests = connections.requestPing();
            CompletionStage nodes = requests.getOrTimeout(seed.getTimeout(), this.eventExecutors);
            return Mono.fromCompletionStage(nodes).flatMap(it -> ResumeAfter.close(connections).thenEmit(it));
        });
    }

    private AsyncConnections getConnections(Iterable<RedisNodeDescription> nodes) {
        List<RedisNodeDescription> nodeList = LettuceLists.newList(nodes);
        AsyncConnections connections = new AsyncConnections(nodeList);
        for (RedisNodeDescription node : nodeList) {
            RedisURI redisURI = node.getUri();
            String message = String.format("Unable to connect to %s", redisURI);
            try {
                CompletableFuture<StatefulRedisConnection<String, String>> connectionFuture = this.nodeConnectionFactory.connectToNodeAsync(CODEC, redisURI);
                CompletableFuture<StatefulRedisConnection<String, String>> sync = new CompletableFuture<StatefulRedisConnection<String, String>>();
                connectionFuture.whenComplete((connection, throwable) -> {
                    if (throwable != null) {
                        if (throwable instanceof RedisConnectionException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(throwable.getMessage(), (Throwable)throwable);
                            } else {
                                logger.warn(throwable.getMessage());
                            }
                        } else {
                            logger.warn(message, (Throwable)throwable);
                        }
                        sync.completeExceptionally(new RedisConnectionException(message, (Throwable)throwable));
                    } else {
                        connection.async().clientSetname("lettuce#MasterReplicaTopologyRefresh");
                        sync.complete((StatefulRedisConnection<String, String>)connection);
                    }
                });
                connections.addConnection(redisURI, sync);
            }
            catch (RuntimeException e) {
                logger.warn(String.format(message, redisURI), e);
            }
        }
        return connections;
    }

    private static void applyAuthenticationCredentials(List<RedisNodeDescription> nodes, RedisURI seed) {
        for (RedisNodeDescription node : nodes) {
            node.getUri().applyAuthentication(seed);
        }
    }
}

