/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;

class RedisMasterReplicaNode
implements RedisNodeDescription {
    private final RedisURI redisURI;
    private final RedisInstance.Role role;

    RedisMasterReplicaNode(String host, int port, RedisURI seed, RedisInstance.Role role) {
        this.redisURI = RedisURI.builder(seed).withHost(host).withPort(port).build();
        this.role = role;
    }

    @Override
    public RedisURI getUri() {
        return this.redisURI;
    }

    @Override
    public RedisInstance.Role getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisMasterReplicaNode)) {
            return false;
        }
        RedisMasterReplicaNode that = (RedisMasterReplicaNode)o;
        if (!this.redisURI.equals(that.redisURI)) {
            return false;
        }
        return this.role == that.role;
    }

    public int hashCode() {
        int result = this.redisURI.hashCode();
        result = 31 * result + this.role.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [redisURI=").append(this.redisURI);
        sb.append(", role=").append((Object)this.role);
        sb.append(']');
        return sb.toString();
    }
}

