/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Exceptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.RedisMasterReplicaNode;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.ResumeAfter;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.TopologyProvider;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import de.themoep.connectorplugin.lib.lettuce.core.sentinel.api.reactive.RedisSentinelReactiveCommands;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class SentinelTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SentinelTopologyProvider.class);
    private final String masterId;
    private final RedisClient redisClient;
    private final RedisURI sentinelUri;
    private final Duration timeout;

    public SentinelTopologyProvider(String masterId, RedisClient redisClient, RedisURI sentinelUri) {
        LettuceAssert.notEmpty((CharSequence)masterId, "MasterId must not be empty");
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull((Object)sentinelUri, "Sentinel URI must not be null");
        this.masterId = masterId;
        this.redisClient = redisClient;
        this.sentinelUri = sentinelUri;
        this.timeout = sentinelUri.getTimeout();
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        try {
            return this.getNodesAsync().get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public CompletableFuture<List<RedisNodeDescription>> getNodesAsync() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        Mono<StatefulRedisSentinelConnection<String, String>> connect = Mono.fromFuture(this.redisClient.connectSentinelAsync(StringCodec.UTF8, this.sentinelUri));
        return connect.flatMap(this::getNodes).toFuture();
    }

    protected Mono<List<RedisNodeDescription>> getNodes(StatefulRedisSentinelConnection<String, String> connection) {
        RedisSentinelReactiveCommands<String, String> reactive = connection.reactive();
        Mono<List> masterAndReplicas = reactive.master(this.masterId).zipWith(reactive.slaves(this.masterId).collectList()).timeout(this.timeout).flatMap(tuple -> ResumeAfter.close(connection).thenEmit(tuple)).doOnError(e -> connection.closeAsync());
        return masterAndReplicas.map(tuple -> {
            ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
            result.add(this.toNode((Map)tuple.getT1(), RedisInstance.Role.UPSTREAM));
            result.addAll(((List)tuple.getT2()).stream().filter(SentinelTopologyProvider::isAvailable).map(map -> this.toNode((Map<String, String>)map, RedisInstance.Role.REPLICA)).collect(Collectors.toList()));
            return result;
        });
    }

    private static boolean isAvailable(Map<String, String> map) {
        String flags = map.get("flags");
        return flags == null || !flags.contains("s_down") && !flags.contains("o_down") && !flags.contains("disconnected");
    }

    private RedisNodeDescription toNode(Map<String, String> map, RedisInstance.Role role) {
        String ip = map.get("ip");
        String port = map.get("port");
        return new RedisMasterReplicaNode(ip, Integer.parseInt(port), this.sentinelUri, role);
    }
}

