/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.event.jfr.EventRecorder;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.MasterReplicaChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.MasterReplicaConnectionProvider;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.MasterReplicaConnector;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.MasterReplicaTopologyChangedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.MasterReplicaTopologyRefresh;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnectionImpl;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.StaticMasterReplicaTopologyProvider;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

class StaticMasterReplicaConnector<K, V>
implements MasterReplicaConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final Iterable<RedisURI> redisURIs;

    StaticMasterReplicaConnector(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURIs = redisURIs;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        HashMap initialConnections = new HashMap();
        StaticMasterReplicaTopologyProvider topologyProvider = new StaticMasterReplicaTopologyProvider(this.redisClient, this.redisURIs);
        RedisURI seedNode = this.redisURIs.iterator().next();
        MasterReplicaTopologyRefresh refresh = new MasterReplicaTopologyRefresh(this.redisClient, topologyProvider);
        MasterReplicaConnectionProvider<K, V> connectionProvider = new MasterReplicaConnectionProvider<K, V>(this.redisClient, this.codec, seedNode, initialConnections);
        return refresh.getNodes(seedNode).flatMap(nodes -> {
            EventRecorder.getInstance().record(new MasterReplicaTopologyChangedEvent(seedNode, (List<RedisNodeDescription>)nodes));
            if (nodes.isEmpty()) {
                return Mono.error(new RedisException(String.format("Cannot determine topology from %s", this.redisURIs)));
            }
            return this.initializeConnection(this.codec, seedNode, connectionProvider, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, RedisURI seedNode, MasterReplicaConnectionProvider<K, V> connectionProvider, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        MasterReplicaChannelWriter channelWriter = new MasterReplicaChannelWriter(connectionProvider, this.redisClient.getResources());
        StatefulRedisMasterReplicaConnectionImpl<K, V> connection = new StatefulRedisMasterReplicaConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout());
        connection.setOptions(this.redisClient.getOptions());
        return Mono.just(connection);
    }
}

