/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.masterreplica;

import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Exceptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.RedisMasterReplicaNode;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.ResumeAfter;
import de.themoep.connectorplugin.lib.lettuce.core.masterreplica.TopologyProvider;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisNodeDescription;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RoleParser;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

class StaticMasterReplicaTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StaticMasterReplicaTopologyProvider.class);
    private final RedisClient redisClient;
    private final Iterable<RedisURI> redisURIs;

    public StaticMasterReplicaTopologyProvider(RedisClient redisClient, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull((Object)redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        LettuceAssert.notNull((Object)redisURIs.iterator().hasNext(), "RedisURIs must not be empty");
        this.redisClient = redisClient;
        this.redisURIs = redisURIs;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        RedisURI next = this.redisURIs.iterator().next();
        try {
            return this.getNodesAsync().get(next.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public CompletableFuture<List<RedisNodeDescription>> getNodesAsync() {
        CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
        Flux<RedisURI> uris = Flux.fromIterable(this.redisURIs);
        Mono nodes = uris.flatMap(uri -> this.getNodeDescription(connections, (RedisURI)uri)).collectList().flatMap(nodeDescriptions -> {
            if (nodeDescriptions.isEmpty()) {
                return Mono.error(new RedisConnectionException(String.format("Failed to connect to at least one node in %s", this.redisURIs)));
            }
            return Mono.just(nodeDescriptions);
        });
        return nodes.toFuture();
    }

    private Mono<RedisNodeDescription> getNodeDescription(List<StatefulRedisConnection<String, String>> connections, RedisURI uri) {
        return Mono.fromCompletionStage(this.redisClient.connectAsync(StringCodec.UTF8, uri)).onErrorResume(t -> {
            logger.warn("Cannot connect to {}", (Object)uri, t);
            return Mono.empty();
        }).doOnNext(connections::add).flatMap(connection -> {
            Mono<RedisNodeDescription> instance = StaticMasterReplicaTopologyProvider.getNodeDescription(uri, connection);
            return instance.flatMap(it -> ResumeAfter.close(connection).thenEmit(it)).doFinally(s -> connections.remove(connection));
        });
    }

    private static Mono<RedisNodeDescription> getNodeDescription(RedisURI uri, StatefulRedisConnection<String, String> connection) {
        return connection.reactive().role().collectList().map(RoleParser::parse).map(it -> new RedisMasterReplicaNode(uri.getHost(), uri.getPort(), uri, it.getRole()));
    }
}

