/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.models.role;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.ReplicationPartner;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class RedisUpstreamInstance
implements RedisInstance,
Serializable {
    private long replicationOffset;
    private List<ReplicationPartner> replicas = Collections.emptyList();

    public RedisUpstreamInstance() {
    }

    public RedisUpstreamInstance(long replicationOffset, List<ReplicationPartner> replicas) {
        LettuceAssert.notNull(replicas, "Replicas must not be null");
        this.replicationOffset = replicationOffset;
        this.replicas = replicas;
    }

    @Override
    public RedisInstance.Role getRole() {
        return RedisInstance.Role.UPSTREAM;
    }

    public long getReplicationOffset() {
        return this.replicationOffset;
    }

    @Deprecated
    public List<ReplicationPartner> getSlaves() {
        return this.getReplicas();
    }

    public List<ReplicationPartner> getReplicas() {
        return this.replicas;
    }

    public void setReplicationOffset(long replicationOffset) {
        this.replicationOffset = replicationOffset;
    }

    @Deprecated
    public void setSlaves(List<ReplicationPartner> replicas) {
        this.setReplicas(replicas);
    }

    public void setReplicas(List<ReplicationPartner> replicas) {
        LettuceAssert.notNull(replicas, "Replicas must not be null");
        this.replicas = replicas;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [replicationOffset=").append(this.replicationOffset);
        sb.append(", replicas=").append(this.replicas);
        sb.append(']');
        return sb.toString();
    }
}

