/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.models.role;

import de.themoep.connectorplugin.lib.lettuce.core.internal.HostAndPort;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisMasterInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisReplicaInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.RedisSentinelInstance;
import de.themoep.connectorplugin.lib.lettuce.core.models.role.ReplicationPartner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RoleParser {
    protected static final Map<String, RedisInstance.Role> ROLE_MAPPING;
    protected static final Map<String, RedisReplicaInstance.State> REPLICA_STATE_MAPPING;

    private RoleParser() {
    }

    public static RedisInstance parse(List<?> roleOutput) {
        LettuceAssert.isTrue(roleOutput != null && !roleOutput.isEmpty(), "Empty role output");
        LettuceAssert.isTrue(roleOutput.get(0) instanceof String && ROLE_MAPPING.containsKey(roleOutput.get(0)), () -> "First role element must be a string (any of " + ROLE_MAPPING.keySet() + ")");
        RedisInstance.Role role = ROLE_MAPPING.get(roleOutput.get(0));
        switch (role) {
            case MASTER: 
            case UPSTREAM: {
                return RoleParser.parseUpstream(roleOutput);
            }
            case SLAVE: 
            case REPLICA: {
                return RoleParser.parseReplica(roleOutput);
            }
            case SENTINEL: {
                return RoleParser.parseSentinel(roleOutput);
            }
        }
        return null;
    }

    private static RedisInstance parseUpstream(List<?> roleOutput) {
        long replicationOffset = RoleParser.getUpstreamReplicationOffset(roleOutput);
        List<ReplicationPartner> replicas = RoleParser.getUpstreamReplicaReplicationPartners(roleOutput);
        RedisMasterInstance redisUpstreamInstanceRole = new RedisMasterInstance(replicationOffset, Collections.unmodifiableList(replicas));
        return redisUpstreamInstanceRole;
    }

    private static RedisInstance parseReplica(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        String stateString = RoleParser.getStringFromIterator(iterator, null);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        ReplicationPartner master2 = new ReplicationPartner(HostAndPort.of(ip, Math.toIntExact(port)), replicationOffset);
        RedisReplicaInstance.State state = REPLICA_STATE_MAPPING.get(stateString);
        return new RedisReplicaInstance(master2, state);
    }

    private static RedisInstance parseSentinel(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        List<String> monitoredMasters = RoleParser.getMonitoredUpstreams(iterator);
        RedisSentinelInstance result = new RedisSentinelInstance(Collections.unmodifiableList(monitoredMasters));
        return result;
    }

    private static List<String> getMonitoredUpstreams(Iterator<?> iterator) {
        ArrayList<String> monitoredUpstreams = new ArrayList<String>();
        if (!iterator.hasNext()) {
            return monitoredUpstreams;
        }
        Object upstreams = iterator.next();
        if (!(upstreams instanceof Collection)) {
            return monitoredUpstreams;
        }
        for (Object upstream : (Collection)upstreams) {
            if (!(upstream instanceof String)) continue;
            monitoredUpstreams.add((String)upstream);
        }
        return monitoredUpstreams;
    }

    private static List<ReplicationPartner> getUpstreamReplicaReplicationPartners(List<?> roleOutput) {
        ArrayList<ReplicationPartner> replicas = new ArrayList<ReplicationPartner>();
        if (roleOutput.size() > 2 && roleOutput.get(2) instanceof Collection) {
            Collection segments = (Collection)roleOutput.get(2);
            for (Object output : segments) {
                if (!(output instanceof Collection)) continue;
                ReplicationPartner replicationPartner = RoleParser.getReplicationPartner((Collection)output);
                replicas.add(replicationPartner);
            }
        }
        return replicas;
    }

    private static ReplicationPartner getReplicationPartner(Collection<?> segments) {
        Iterator<?> iterator = segments.iterator();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        return new ReplicationPartner(HostAndPort.of(ip, Math.toIntExact(port)), replicationOffset);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }

    private static String getStringFromIterator(Iterator<?> iterator, String defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return (String)object;
        }
        return defaultValue;
    }

    private static long getUpstreamReplicationOffset(List<?> roleOutput) {
        long replicationOffset = 0L;
        if (roleOutput.size() > 1 && roleOutput.get(1) instanceof Number) {
            Number number = (Number)roleOutput.get(1);
            replicationOffset = number.longValue();
        }
        return replicationOffset;
    }

    static {
        HashMap<String, RedisInstance.Role> roleMap = new HashMap<String, RedisInstance.Role>();
        roleMap.put("master", RedisInstance.Role.UPSTREAM);
        roleMap.put("slave", RedisInstance.Role.REPLICA);
        roleMap.put("sentinel", RedisInstance.Role.SENTINEL);
        ROLE_MAPPING = Collections.unmodifiableMap(roleMap);
        HashMap<String, RedisReplicaInstance.State> replicas = new HashMap<String, RedisReplicaInstance.State>();
        replicas.put("connect", RedisReplicaInstance.State.CONNECT);
        replicas.put("connected", RedisReplicaInstance.State.CONNECTED);
        replicas.put("connecting", RedisReplicaInstance.State.CONNECTING);
        replicas.put("sync", RedisReplicaInstance.State.SYNC);
        REPLICA_STATE_MAPPING = Collections.unmodifiableMap(replicas);
    }
}

