/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.models.stream;

import java.time.Duration;

public class PendingMessage {
    private final String id;
    private final String consumer;
    private final long msSinceLastDelivery;
    private final long redeliveryCount;

    public PendingMessage(String id, String consumer, long msSinceLastDelivery, long redeliveryCount) {
        this.id = id;
        this.consumer = consumer;
        this.msSinceLastDelivery = msSinceLastDelivery;
        this.redeliveryCount = redeliveryCount;
    }

    public String getId() {
        return this.id;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public long getMsSinceLastDelivery() {
        return this.msSinceLastDelivery;
    }

    public Duration getSinceLastDelivery() {
        return Duration.ofMillis(this.getMsSinceLastDelivery());
    }

    public long getRedeliveryCount() {
        return this.redeliveryCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PendingMessage)) {
            return false;
        }
        PendingMessage that = (PendingMessage)o;
        if (this.msSinceLastDelivery != that.msSinceLastDelivery) {
            return false;
        }
        if (this.redeliveryCount != that.redeliveryCount) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.consumer != null ? this.consumer.equals(that.consumer) : that.consumer == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.consumer != null ? this.consumer.hashCode() : 0);
        result = 31 * result + (int)(this.msSinceLastDelivery ^ this.msSinceLastDelivery >>> 32);
        result = 31 * result + (int)(this.redeliveryCount ^ this.redeliveryCount >>> 32);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [id='").append(this.id).append('\'');
        sb.append(", consumer='").append(this.consumer).append('\'');
        sb.append(", msSinceLastDelivery=").append(this.msSinceLastDelivery);
        sb.append(", redeliveryCount=").append(this.redeliveryCount);
        sb.append(']');
        return sb.toString();
    }
}

