/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.StreamMessage;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.models.stream.ClaimedMessages;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClaimedMessagesOutput<K, V>
extends CommandOutput<K, V, ClaimedMessages<K, V>> {
    private final boolean justId;
    private final K stream;
    private String startId;
    private String id;
    private K key;
    private Map<K, V> body;
    private boolean bodyReceived;
    private final List<StreamMessage<K, V>> messages;

    public ClaimedMessagesOutput(RedisCodec<K, V> codec, K stream, boolean justId) {
        super(codec, null);
        this.stream = stream;
        this.messages = new ArrayList<StreamMessage<K, V>>();
        this.justId = justId;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.startId == null) {
            this.startId = this.decodeAscii(bytes);
            return;
        }
        if (this.id == null) {
            this.id = this.decodeAscii(bytes);
            return;
        }
        if (this.justId) {
            return;
        }
        if (this.key == null) {
            this.bodyReceived = true;
            if (bytes == null) {
                return;
            }
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.body == null) {
            this.body = new LinkedHashMap();
        }
        this.body.put(this.key, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
        this.key = null;
    }

    @Override
    public void complete(int depth) {
        if (depth == 3 && this.bodyReceived) {
            this.messages.add(new StreamMessage(this.stream, this.id, this.body == null ? Collections.emptyMap() : this.body));
            this.bodyReceived = false;
            this.key = null;
            this.body = null;
            this.id = null;
        }
        if (depth == 2 && this.justId) {
            this.messages.add(new StreamMessage(this.stream, this.id, null));
            this.key = null;
            this.body = null;
            this.id = null;
        }
        if (depth == 0) {
            this.output = new ClaimedMessages<K, V>(this.startId, Collections.unmodifiableList(this.messages));
        }
    }
}

