/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.GeoCoordinates;
import de.themoep.connectorplugin.lib.lettuce.core.GeoWithin;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListSubscriber;
import de.themoep.connectorplugin.lib.lettuce.core.output.OutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class GeoWithinListOutput<K, V>
extends CommandOutput<K, V, List<GeoWithin<V>>>
implements StreamingOutput<GeoWithin<V>> {
    private V member;
    private Double distance;
    private Long geohash;
    private GeoCoordinates coordinates;
    private Double x;
    private boolean withDistance;
    private boolean withHash;
    private boolean withCoordinates;
    private StreamingOutput.Subscriber<GeoWithin<V>> subscriber;

    public GeoWithinListOutput(RedisCodec<K, V> codec, boolean withDistance, boolean withHash, boolean withCoordinates) {
        super(codec, OutputFactory.newList(16));
        this.withDistance = withDistance;
        this.withHash = withHash;
        this.withCoordinates = withCoordinates;
        this.setSubscriber((StreamingOutput.Subscriber<GeoWithin<V>>)ListSubscriber.instance());
    }

    @Override
    public void set(long integer) {
        if (this.member == null) {
            this.member = integer;
            return;
        }
        if (this.withHash) {
            this.geohash = integer;
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.member == null) {
            this.member = this.codec.decodeValue(bytes);
            return;
        }
        double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        this.set(value);
    }

    @Override
    public void set(double number) {
        if (this.withDistance && this.distance == null) {
            this.distance = number;
            return;
        }
        if (this.withCoordinates) {
            if (this.x == null) {
                this.x = number;
                return;
            }
            this.coordinates = new GeoCoordinates(this.x, number);
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 1) {
            this.subscriber.onNext((Collection)this.output, new GeoWithin<V>(this.member, this.distance, this.geohash, this.coordinates));
            this.member = null;
            this.distance = null;
            this.geohash = null;
            this.coordinates = null;
            this.x = null;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<GeoWithin<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<GeoWithin<V>> getSubscriber() {
        return this.subscriber;
    }
}

