/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListSubscriber;
import de.themoep.connectorplugin.lib.lettuce.core.output.OutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IntegerListOutput<K, V>
extends CommandOutput<K, V, List<Long>>
implements StreamingOutput<Long> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Long> subscriber;

    public IntegerListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Long>)ListSubscriber.instance());
    }

    @Override
    public void set(long integer) {
        this.subscriber.onNext((Collection)this.output, integer);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Long> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Long> getSubscriber() {
        return this.subscriber;
    }
}

