/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListSubscriber;
import de.themoep.connectorplugin.lib.lettuce.core.output.OutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KeyListOutput<K, V>
extends CommandOutput<K, V, List<K>>
implements StreamingOutput<K> {
    private boolean initialized;
    private StreamingOutput.Subscriber<K> subscriber;

    public KeyListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber(ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        this.subscriber.onNext((Collection)this.output, bytes == null ? null : (Object)this.codec.decodeKey(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<K> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<K> getSubscriber() {
        return this.subscriber;
    }
}

