/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.KeyValue;
import de.themoep.connectorplugin.lib.lettuce.core.ScoredValue;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceStrings;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, ScoredValue<V>>> {
    private K key;
    private V value;

    public KeyValueScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.output = KeyValue.just(this.key, ScoredValue.just(number, this.value));
        this.key = null;
        this.value = null;
    }
}

