/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.api.push.PushMessage;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.output.NestedMultiOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class PushOutput<K, V>
extends NestedMultiOutput<K, V>
implements PushMessage {
    private String type;

    public PushOutput(RedisCodec<K, V> codec) {
        super(codec);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.type == null) {
            bytes.mark();
            this.type = StringCodec.ASCII.decodeKey(bytes);
            bytes.reset();
        }
        super.set(bytes);
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        if (this.type == null) {
            this.set(bytes);
        }
        super.setSingle(bytes);
    }

    public String type() {
        return this.type;
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public List<Object> getContent() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>();
        for (Object o : (List)this.get()) {
            if (o instanceof ByteBuffer) {
                copy.add(((ByteBuffer)o).asReadOnlyBuffer());
                continue;
            }
            copy.add((ByteBuffer)o);
        }
        return Collections.unmodifiableList(copy);
    }

    @Override
    public List<Object> getContent(Function<ByteBuffer, Object> decodeFunction) {
        LettuceAssert.notNull(decodeFunction, "Decode function must not be null");
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Object o : (List)this.get()) {
            copy.add(this.decode(o, decodeFunction));
        }
        return Collections.unmodifiableList(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decode(Object toDecode, Function<ByteBuffer, Object> decodeFunction) {
        if (toDecode instanceof List) {
            ArrayList<Object> copy = new ArrayList<Object>(((List)toDecode).size());
            for (Object o : (List)toDecode) {
                copy.add(this.decode(o, decodeFunction));
            }
            return copy;
        }
        if (toDecode instanceof Set) {
            LinkedHashSet<Object> copy = new LinkedHashSet<Object>(((Set)toDecode).size());
            for (Object o : (Set)toDecode) {
                copy.add(this.decode(o, decodeFunction));
            }
            return copy;
        }
        if (toDecode instanceof Map) {
            LinkedHashMap copy = new LinkedHashMap(((Map)toDecode).size());
            ((Map)toDecode).forEach((k, v) -> copy.put(this.decode(k, decodeFunction), this.decode(v, decodeFunction)));
            return copy;
        }
        if (toDecode instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)toDecode;
            try {
                buffer.mark();
                Object object = decodeFunction.apply(buffer);
                return object;
            }
            finally {
                buffer.reset();
            }
        }
        return toDecode;
    }
}

