/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.ScoredValue;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceStrings;
import de.themoep.connectorplugin.lib.lettuce.core.output.CommandOutput;
import de.themoep.connectorplugin.lib.lettuce.core.output.ListSubscriber;
import de.themoep.connectorplugin.lib.lettuce.core.output.OutputFactory;
import de.themoep.connectorplugin.lib.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScoredValueListOutput<K, V>
extends CommandOutput<K, V, List<ScoredValue<V>>>
implements StreamingOutput<ScoredValue<V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<ScoredValue<V>> subscriber;
    private V value;

    public ScoredValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<ScoredValue<V>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.subscriber.onNext((Collection)this.output, ScoredValue.just(number, this.value));
        this.value = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<ScoredValue<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<ScoredValue<V>> getSubscriber() {
        return this.subscriber;
    }
}

