/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core.output;

import de.themoep.connectorplugin.lib.lettuce.core.ScoredValue;
import de.themoep.connectorplugin.lib.lettuce.core.ScoredValueScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceStrings;
import de.themoep.connectorplugin.lib.lettuce.core.output.ScanOutput;
import java.nio.ByteBuffer;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.value != null) {
            ((ScoredValueScanCursor)this.output).getValues().add(ScoredValue.just(number, this.value));
        }
        this.value = null;
    }
}

